package ip.raul;

public class Vec3Float {
    float x;
    float y;
    float z;

    public Vec3Float() {
    }

    public Vec3Float(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static float length(Vec3Float v) {
        return (float) Math.sqrt(
                v.x * v.x + v.y * v.y +
                v.z * v.z);
    }

    public static Vec3Float normalize(Vec3Float v) {
        float length = length(v);
        return new Vec3Float(v.x / length,
                                v.y / length,
                                v.z / length);
    }

    public static Vec3Float vectordist(
            Vec3Float v1, Vec3Float v2) {
        return new Vec3Float(v1.x - v2.x,
                                v1.y - v2.y,
                                v1.z - v2.z);
    }

    public static Vec3Float getNormal(Vec3Float a,
                                  Vec3Float b,
                                  Vec3Float c) {
        Vec3Float n = new Vec3Float();
        float ax = b.x - a.x;
        float ay = b.y - a.y;
        float az = b.z - a.z;
        float bx = c.x - a.x;
        float by = c.y - a.y;
        float bz = c.z - a.z;
        n.x = ay * bz - by * az;
        n.y = az * bx - bz * ax;
        n.z = ax * by - bx * ay;
        return normalize(n);
    }
}
