package ip.raul;

import ip.gui.dialog.MessLog;

import java.awt.*;
import java.awt.event.*;


public class ObjectInfo extends
        Dialog implements ActionListener, ItemListener, WindowListener {

    private TextField fields[];
    private Label labels[];
    public Choice names = new Choice();
    private Choice texture = new Choice();
    public Button cancelButton = new Button("Cancel");
    public Button setButton = new Button("Set");
    private String userInput;
    private int fieldSize;
    public Object3D objects[] = null;
    public int maxTextures;

    private static int colSpace = 5;
    private static int rowSpace = 10;
    private Panel inputPanel = new Panel();

    public ObjectInfo(
            String title,
            Object3D _objects[], int maxObjects, int _maxTextures) {
        super(new Frame(), title, false);
        objects = _objects;
        maxTextures = _maxTextures;
        initialize(maxObjects);
        pack();
        show();
    }

    private void initialize(int maxObjects) {
        fieldSize = 6;
        fields = new TextField[12];

        names.removeAll();
        if (maxObjects >= 0) {
            for (int i = 0; i <= maxObjects; i++)
                names.addItem(objects[i].name);
            names.select(names.getItem(0));
        }
        texture.removeAll();
        texture.addItem("none");
        if (maxTextures >= 0) {
            for (int i = 0; i <= maxTextures; i++)
                texture.addItem("Texture " + (i + 1));
        }
        texture.select(names.getItem(0));

        if (maxObjects >= 0) {
            fields[0] = new TextField("" + objects[0].Pos.x, fieldSize);
            fields[1] = new TextField("" + objects[0].Pos.y, fieldSize);
            fields[2] = new TextField("" + objects[0].Pos.z, fieldSize);
            fields[3] = new TextField("" + objects[0].Rot.x, fieldSize);
            fields[4] = new TextField("" + objects[0].Rot.y, fieldSize);
            fields[5] = new TextField("" + objects[0].Rot.z, fieldSize);
            fields[6] = new TextField("" + objects[0].Sca.x, fieldSize);
            fields[7] = new TextField("" + objects[0].Sca.y, fieldSize);
            fields[8] = new TextField("" + objects[0].Sca.z, fieldSize);
            fields[9] = new TextField("" + objects[0].Cen.x, fieldSize);
            fields[10] = new TextField("" + objects[0].Cen.y, fieldSize);
            fields[11] = new TextField("" + objects[0].Cen.z, fieldSize);
            texture.select(objects[0].textureIndex + 1);
        } else
            for (int i = 0; i < 12; i++)
                fields[i] = new TextField("0.00", fieldSize);
        inputPanel.setLayout(new GridLayout(5, 5, colSpace, rowSpace));
        inputPanel.add(new Label("Names:"));
        inputPanel.add(names);
        inputPanel.add(new Label("Texture:"));
        inputPanel.add(texture);
//      inputPanel.add(new Label("    "));
        inputPanel.add(new Label("    "));

        inputPanel.add(new Label("    "));
        inputPanel.add(new Label("Position"));
        inputPanel.add(new Label("Rotation"));
        inputPanel.add(new Label("Scale"));
        inputPanel.add(new Label("Center"));
        inputPanel.add(new Label("  X "));
        inputPanel.add(fields[0]);
        inputPanel.add(fields[3]);
        inputPanel.add(fields[6]);
        inputPanel.add(fields[9]);
        inputPanel.add(new Label("  Y "));
        inputPanel.add(fields[1]);
        inputPanel.add(fields[4]);
        inputPanel.add(fields[7]);
        inputPanel.add(fields[10]);
        inputPanel.add(new Label("  Z "));
        inputPanel.add(fields[2]);
        inputPanel.add(fields[5]);
        inputPanel.add(fields[8]);
        inputPanel.add(fields[11]);
        add("Center", inputPanel);
        buttonPanel();
        addWindowListener(this);
    }


    private void buttonPanel() {
        Panel p2 = new Panel();
        p2.setLayout(new FlowLayout(FlowLayout.RIGHT));
        p2.add(cancelButton);
        p2.add(setButton);
        cancelButton.addActionListener(this);
        setButton.addActionListener(this);
        names.addItemListener(this);
        add("South", p2);
        pack();
        show();
    }


    private void Names_Click() {
        try {
            int i1 = 0;
            i1 = names.getSelectedIndex();
            fields[0].setText("" + objects[i1].Pos.x);
            fields[1].setText("" + objects[i1].Pos.y);
            fields[2].setText("" + objects[i1].Pos.z);
            fields[3].setText("" + objects[i1].Rot.x);
            fields[4].setText("" + objects[i1].Rot.y);
            fields[5].setText("" + objects[i1].Rot.z);
            fields[6].setText("" + objects[i1].Sca.x);
            fields[7].setText("" + objects[i1].Sca.y);
            fields[8].setText("" + objects[i1].Sca.z);
            fields[9].setText("" + objects[i1].Cen.x);
            fields[10].setText("" + objects[i1].Cen.y);
            fields[11].setText("" + objects[i1].Cen.z);
            texture.select(objects[i1].textureIndex + 1);
        } catch (Exception ex) {
        }
    }


    private void setThem() {
        String txt = new String();
        int i1 = 0;
        int j1 = 0;

        Float f;
        try {
            i1 = names.getSelectedIndex();
            j1 = texture.getSelectedIndex();
        } catch (Exception ex) {
        }

        try {
            f = Float.valueOf(fields[0].getText());
            objects[i1].Pos.x = f.floatValue();
            f = Float.valueOf(fields[1].getText());
            objects[i1].Pos.y = f.floatValue();
            f = Float.valueOf(fields[2].getText());
            objects[i1].Pos.z = f.floatValue();
            f = Float.valueOf(fields[3].getText());
            objects[i1].Rot.x = f.floatValue();
            f = Float.valueOf(fields[4].getText());
            objects[i1].Rot.y = f.floatValue();
            f = Float.valueOf(fields[5].getText());
            objects[i1].Rot.z = f.floatValue();
            f = Float.valueOf(fields[6].getText());
            objects[i1].Sca.x = f.floatValue();
            f = Float.valueOf(fields[7].getText());
            objects[i1].Sca.y = f.floatValue();
            f = Float.valueOf(fields[8].getText());
            objects[i1].Sca.z = f.floatValue();
            f = Float.valueOf(fields[9].getText());
            objects[i1].Cen.x = f.floatValue();
            f = Float.valueOf(fields[10].getText());
            objects[i1].Cen.y = f.floatValue();
            f = Float.valueOf(fields[11].getText());
            objects[i1].Cen.z = f.floatValue();
            objects[i1].textureIndex = j1 - 1;
        } catch (NumberFormatException e) {
            MessLog ml =
                    new MessLog(
                            new Frame(),
                            "Input Error:",
                            "Could not convert to Float");
        }

    }


    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == names) {
            Names_Click();
            return;
        }
    }

    public void actionPerformed(ActionEvent e) {
        Button b = (Button) e.getSource();
        if (b == cancelButton) setVisible(false);
        if (b == setButton) setThem();
    }

    public void windowClosing(WindowEvent e) {
        dispose();
    }

    public void windowClosed(WindowEvent e) {
    };
    public void windowDeiconified(WindowEvent e) {
    };
    public void windowIconified(WindowEvent e) {
    };
    public void windowActivated(WindowEvent e) {
    };
    public void windowDeactivated(WindowEvent e) {
    };
    public void windowOpened(WindowEvent e) {
    };

}








