package ip.raul;

import gui.ClosableJFrame;
import j2d.ShortImageBean;

import java.awt.*;


public class Fractals {
    private int maxIter = 30;
    private static float xMin = -2f;
    private static float yMax = 1.5f;
    private static float xMax = 1f;
    private static float yMin = -1.5f;
    private short colorR[] = new short[maxIter];
    private short colorG[] = new short[maxIter];
    private short colorB[] = new short[maxIter];

    public Fractals() {
//make some colors, that's all
        float deltaTheta = (float) (Math.PI / maxIter);
        for (int i = 0; i < maxIter; i++) {
            colorR[i] = (short) (Math.sin((i * deltaTheta)) * 255f);
            colorG[i] = 0;
            colorB[i] = (short) (i * 255 / maxIter);
        }
    }


    public int getColor(float pixelr, float pixeli) {
        float zr = 0;
        float zi = 0;
        float tmp = 0;
        int iter = 0;
        //z*z+c, in complex basically;
        do {
            iter++;
            tmp = zr;
            zr = zr * zr - zi * zi;
            zi = 2 * tmp * zi;
            zr = zr + pixelr;
            zi = zi + pixeli;
        } while (((zr * zr + zi * zi) <= 300) && (iter <= maxIter));
        if (iter > maxIter)
            return -1;
        else
            return iter;
    }
    public static void testMandelbrot() {
        ClosableJFrame cjf = new ClosableJFrame("mandlebrot"){
            public void paint(Graphics g){
                Dimension d = getSize();
                Image i = getMandelbrot(d.width,d.height);
                g.drawImage(i,0,0,this);
            }

        };
        cjf.setSize(400,400);
        cjf.show();
    }
    public static void main(String args[]){
        testMandelbrot();
    }
    public static Image getMandelbrot(int w, int h){
        ShortImageBean sib = new ShortImageBean(w,h);
        Fractals f = new Fractals();
        f.mandelbrot(sib.getR(), sib.getG(), sib.getB());
        return sib.getImage();
    }
    public void mandelbrot(short[][] r, short[][] g, short[][] b) {
        int height = r[0].length;
        int width = r.length;
        int Clr;
        float pixelr,pixeli;
        for (int y = 0; y < height; y++)
            for (int x = 0; x < width; x++) {
                pixelr = xMin + (float) x / width * (xMax - xMin);
                pixeli = yMin + (float) y / height * (yMax - yMin);
                Clr = getColor(pixelr, pixeli);
                if (Clr == -1) {
                    r[x][y] = 255;
                    g[x][y] = 128;
                    b[x][y] = 0;
                } else {
                    r[x][y] = colorR[Clr % maxIter];
                    g[x][y] = colorG[Clr % maxIter];
                    b[x][y] = colorB[Clr % maxIter];
                }
            }
    }

    public int getMaxIter() {
        return maxIter;
    }

    public void setMaxIter(int maxIter) {
        this.maxIter = maxIter;
    }

    public static float getxMin() {
        return xMin;
    }

    public static void setxMin(float xMin) {
        Fractals.xMin = xMin;
    }

    public static float getyMax() {
        return yMax;
    }

    public static void setyMax(float yMax) {
        Fractals.yMax = yMax;
    }

    public static float getxMax() {
        return xMax;
    }

    public static void setxMax(float xMax) {
        Fractals.xMax = xMax;
    }

    public static float getyMin() {
        return yMin;
    }

    public static void setyMin(float yMin) {
        Fractals.yMin = yMin;
    }

    public short[] getColorR() {
        return colorR;
    }

    public void setColorR(short[] colorR) {
        this.colorR = colorR;
    }

    public short[] getColorG() {
        return colorG;
    }

    public void setColorG(short[] colorG) {
        this.colorG = colorG;
    }

    public short[] getColorB() {
        return colorB;
    }

    public void setColorB(short[] colorB) {
        this.colorB = colorB;
    }
}