package ip.martelli;


import ip.gui.EdgeElement;

import java.util.Vector;


public class EdgeElements {
    private Vector edgeVector = new Vector();

    public void add(EdgeElement e) {
        edgeVector.addElement(e);
    }

    public EdgeElement getElementAt(int i) {
        return (EdgeElement) edgeVector.elementAt(i);
    }

    public int getSize() {
        return edgeVector.size();
    }

    public EdgeElement getMinOpenNode() {
        if (getSize() == 0) return null;
        int minCost = 1000000;
        EdgeElement lowCostEdgeElement = new EdgeElement();
        lowCostEdgeElement.setOpen(true);
        lowCostEdgeElement.setCost(minCost);
        for (int i = 0; i < getSize(); i++) {
            EdgeElement el = getElementAt(i);
            if (!el.isOpen()) continue;
            if (el.getCost() > lowCostEdgeElement.getCost()) continue;
            lowCostEdgeElement = el;
        }
        if (lowCostEdgeElement.getCost() == minCost) return null;
        return lowCostEdgeElement;
    }

    public static int countPath(EdgeElement pos) {
        int i = 0;
        while (pos != null) {
            i++;
            pos = pos.getParent();
        }
        return i;
    }


}



