/**
 * Victor Silva - University of Bridgeport 27 April 1997
 *
 * Computes and displays the histogram for each primary
 * color of an image that was previously read.
 *
 * modified by DL 3/12/98...made 2D, added CMF, etc.
 */
package ip.gui.frames;

import graphics.dclap.SavePICT;
import math.MatFloat;
import math.Stats;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileOutputStream;
import java.io.IOException;


public class HistogramFrame
        extends ShortCutFrame implements ActionListener {
    private int FRAME_WIDTH = 275;
    private int FRAME_HEIGHT = 150;
    private int Ysize =
            getToolkit().getScreenSize().height;
    private static int startx = 256;
    private static int starty = 0;
    private Menu fileMenu = getMenu("File");
    private MenuItem print_mi = addMenuItem(fileMenu, "[p]rint");
    private MenuItem save_mi = addMenuItem(fileMenu, "[s]ave as pict");
    private Font f = new Font("Times", Font.PLAIN, 12);

    Stats stats = new Stats();

    public HistogramFrame(String title) {
        super(title);
    }

    private void initMenu() {
        MenuBar mb = new MenuBar();
        mb.add(fileMenu);
        setMenuBar(mb);
    }

    private void moveFrame(int x, int y) {
        setBounds(x, y,
                FRAME_WIDTH, FRAME_HEIGHT);
    }

    public void myShow() {
        moveFrame(startx, starty);
        starty += FRAME_HEIGHT;
        if (starty * 1.5 > Ysize) starty = 0;
        super.setVisible(true);
    }

    public double[] getCMF() {
        return stats.getCMF();
    }

    public void printPMF() {
        stats.printPMF();
    }

    public void printCMF() {
        stats.printCMF();
    }

    public HistogramFrame(short plane[][], String title) {
        super(title);
        setSize(FRAME_WIDTH, FRAME_HEIGHT);
        initMenu();
        setResizable(true);
        stats.initStats(plane);
    }

    //private void save() {
    //	ip.gui.SaveFrame.print(this);
// }
    private void save() {
        FileDialog fd = new FileDialog(this,
                "Enter a pict file name", FileDialog.SAVE);
        fd.setVisible(true);
        fd.setVisible(false);
        String fn = fd.getDirectory() + fd.getFile();
        //if usr canceled, return
        if (fd.getFile() == null) return;
        try {
            FileOutputStream fos =
                    new FileOutputStream(fn);
            Component c = this;
            SavePICT p = new SavePICT();
            p.saveAsPict(c, fos);
            fos.close();
        } catch (IOException e) {
            System.out.println(e);
        }
    }


    public void actionPerformed(ActionEvent e) {
        if (match(e, save_mi)) {
            save();
            return;
        }
        if (match(e, print_mi)) {
            print(this);
            return;
        }
        super.actionPerformed(e);
    }

    public void update(Graphics g) {
        Rectangle r = getBounds();
        FRAME_WIDTH = r.width;
        FRAME_HEIGHT = r.height;
        g.clearRect(0, 0, r.width, r.height);
        paint(g);
    }

    public void paint(Graphics g) {

        int leftMargin = 15;
        int bottomMargin = FRAME_HEIGHT - 45;
        g.setFont(f);
        float max = (float) MatFloat.getMax(stats.getPMF());
        float yscale = (float) (0.9 * bottomMargin / max);
        g.drawString("PMF max=" + max,
                leftMargin, bottomMargin + 12);
        for (int i = 0,x1 = leftMargin; i < 256; i++, x1 = i + leftMargin)
            g.drawLine(x1, bottomMargin, x1,
                    bottomMargin - (int) (yscale * stats.getPMF()[i]));
    }

    public static void print(Frame comp) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        PrintJob printJob =
                tk.getPrintJob(
                        comp,
                        "print me!",
                        null);
        Graphics g = printJob.getGraphics();
        comp.print(g);
        printJob.end();
    }
}