package ip.gui.frames;

import bookExamples.ch26Graphics.testPatterns.TestPatternFrame;
import j2d.ImageUtils;
import utils.Print;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.net.URL;

public class GrabFrame extends FilterFrame {

    private JPanel testPatternPanel;
    private String dataHome = "http://show.docjava.com:8086/book/cgij/code/data/";
    private String imagesHome =
            dataHome + "images/gifs/";
    private String imagesColor =
            dataHome + "images/color/";
    private String audioHome =
            dataHome + "audio/";


    private Menu grabMenu = getMenu("Grab");
    private Menu netMenu = getMenu("ip.net");
    private MenuItem building_mi = addMenuItem(netMenu, "BUILDING.GIF");
    private MenuItem plane_mi = addMenuItem(netMenu, "airplane.JPEG");
    private MenuItem baboon_mi = addMenuItem(netMenu, "baboon.JPEG");
    private MenuItem lena_mi = addMenuItem(netMenu, "lena.JPEG");
    private MenuItem peppers_mi = addMenuItem(netMenu, "peppers.JPEG");
    private MenuItem spaceMusic_mi = addMenuItem(netMenu,
            "spacemusic.au");

    private MenuItem testPattern_mi = addMenuItem(grabMenu,
            "display [T]est Patterns");

    private MenuItem grabTestPattern_mi = addMenuItem(grabMenu,
            "[E-G]rab Patterns");

    public void actionPerformed(ActionEvent e) {

        if (match(e, spaceMusic_mi)) {
            netSoundSelector(audioHome + "spacemusic.au");
            return;
        }

        if (match(e, plane_mi)) {
            netImageSelector(imagesColor + "airplane.JPEG");
            return;
        }
        if (match(e, baboon_mi)) {
            netImageSelector(imagesColor + "baboon.JPEG");
            return;
        }
        if (match(e, peppers_mi)) {
            netImageSelector(imagesColor + "peppers.JPEG");
            return;
        }
        if (match(e, lena_mi)) {
            netImageSelector(imagesColor + "lena.JPEG");
            return;
        }
        if (match(e, building_mi)) {
            netImageSelector(imagesHome + building_mi.getActionCommand());
            return;
        }

        if (match(e, testPattern_mi)) {
            testPattern();
            return;
        }
        if (match(e, grabTestPattern_mi)) {
            grabTestPattern();
            return;
        }
        super.actionPerformed(e);
    }

    public GrabFrame(String title) {
        super(title);
        grabMenu.add(netMenu);

        getFileMenu().add(grabMenu);
    }

    public void testPattern() {
        TestPatternFrame tpf = new TestPatternFrame();
        tpf.setSize(200, 200);

        tpf.setVisible(true);
        testPatternPanel = tpf.getDrawPanel();
    }

    public void revert() {
        if (urlString == null) {
            super.revert();
            return;
        }
        netImageSelector(urlString);
    }

    public static void netSoundSelector(String st) {
        URL url = null;
        try {
            url = new URL(st);
        } catch (Exception e) {
            e.printStackTrace();
        }
        netSoundSelector(url);
    }

    public static void netSoundSelector(URL url) {
        sound.ulaw.UlawCodec.play(url);
    }

    public void netImageSelector(String st) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Image img;
        urlString = st;
        URL url = null;
        Print.println("Loading..." + st);
        try {
            url = new URL(st);
        } catch (Exception e) {
            e.printStackTrace();
        }

        img = tk.getImage(url);
        ImageUtils.waitForImage(this, img);
        if (img == null) {
            Print.println("netload failed");
            return;
        }
        setImage(img);
        setSize(getImageWidth(), getImageHeight());
        repaint();
    }

    private String urlString = null;

    public void grab(JPanel f) {
        setImageWidth(f.getSize().width);
        setImageHeight(f.getSize().height);
        Image backBuffer = createImage(getImageWidth(), getImageHeight());
        Graphics g = backBuffer.getGraphics();
        f.paint(g);
        setImage(backBuffer);
        g = getGraphics();
        g.clearRect(0, 0, getSize().width, getSize().height);
        setSize(getImageWidth(), getImageHeight());
        repaint();
    }

    public void grabTestPattern() {
        if (testPatternPanel == null) {
            testPattern();
        }
        grab(testPatternPanel);
    }

    public static void main(String args[]) {
        GrabFrame gf = new GrabFrame("Grab Frame");
        gf.testPattern();
    }

}
