/*
 * Created by DocJava, Inc.
 * User: lyon
 * Date: Apr 21, 2003
 * Time: 8:41:10 AM
 */
package ip.gui;

import j2d.ShortImageBean;

public class MorphUtils {
    public static final
            float kv[][] = {
                {0, 1, 0},
                {0, 1, 0},
                {0, 1, 0}
            };
    public static final
            float kh[][] = {
                {0, 0, 0},
                {1, 1, 1},
                {0, 0, 0}
            };
    public static final
            float kCross[][] = {
                {0, 1, 0},
                {1, 1, 1},
                {0, 1, 0}
            };
    public static final
            float kSquare[][] = {
                {1, 1, 1},
                {1, 1, 1},
                {1, 1, 1}
            };
    public static final
            float kThinTop[][] = {
                {0, 1, 0},
                {1, 1, 1},
                {0, 0, 0}
            };
    public static final
            float kThinBottom[][] = {
                {0, 0, 0},
                {1, 1, 1},
                {0, 1, 0}
            };
    public static final
            float kOutline[][] = {
                {0, 1, 1, 1, 0},
                {1, 1, 1, 1, 1},
                {1, 1, 1, 1, 1},
                {1, 1, 1, 1, 1},
                {0, 1, 1, 1, 0}
            };

    public static short[][] dilategs(short f[][], float k[][]) {
        int uc = k.length / 2;
        int vc = k[0].length / 2;
        int w = f.length;
        int h = f[0].length;

        short o[][] = new short[w][h];
        short max = 0;
        short sum = 0;

        for (int x = uc; x < w - uc; x++) {
            for (int y = vc; y < h - vc; y++) {
                max = 0;
                sum = 0;
                for (int v = -vc; v <= vc; v++)
                    for (int u = -uc; u <= uc; u++)
                        if (k[u + uc][v + vc] == 1) {
                            sum = f[x - u][y - v];
                            if (sum > max)
                                max = sum;
                        }

                o[x][y] = max;
            }
        }
        return o;
    }

    public static short[][] dilate(short f[][], float k[][]) {
        int uc = k.length / 2;
        int vc = k[0].length / 2;
        int w = f.length;
        int h = f[0].length;
        short o[][] = new short[w][h];
        short sum;

        for (int x = uc; x < w - uc; x++) {
            for (int y = vc; y < h - vc; y++) {
                sum = 0;
                for (int v = -vc; v <= vc; v++)
                    for (int u = -uc; u <= uc; u++)
                        if (k[u + uc][v + vc] == 1)
                            if (f[x - u][y - v] > sum)
                                sum = f[x - u][y - v];
                o[x][y] = sum;
            }
        }
        return o;
    }

    public static short redPassSuen(ShortImageBean sib, boolean firstPass) {
        boolean p[] = new boolean[8];
        short c = 0;
        int w = sib.getWidth();
        int h = sib.getHeight();
        for (int x = 1; x < w - 1; x++) {
            for (int y = 1; y < h - 1; y++) {
                sib.getG()[x][y] = 0; // use g for 1st pass
                if (sib.getR()[x][y] == 0) continue;
                p[0] = sib.getR()[x][y + 1] != 0;
                p[1] = sib.getR()[x + 1][y + 1] != 0;
                p[2] = sib.getR()[x + 1][y] != 0;
                p[3] = sib.getR()[x + 1][y - 1] != 0;
                p[4] = sib.getR()[x][y - 1] != 0;
                p[5] = sib.getR()[x - 1][y - 1] != 0;
                p[6] = sib.getR()[x - 1][y] != 0;
                p[7] = sib.getR()[x - 1][y + 1] != 0;
                int n = numberOfNeighbors(p);
                if ((n < 2) || (n > 6)) continue;
                if (numberOf01Transitions(p) != 1) continue;

                if (firstPass) {
                    if ((p[0] && p[2] && p[4]))
                        continue;
                    if ((p[2] && p[4] && p[6]))
                        continue;
                    sib.getG()[x][y] = 255;
                    c++;
                } else {
                    if ((p[0] && p[2] && p[6]))
                        continue;
                    if ((p[0] && p[4] && p[6]))
                        continue;
                    sib.getG()[x][y] = 255;
                    c++;

                }
            }
        }
        return c;
    }

    public static short[][] erodegs(short f[][], float k[][]) {
        int uc = k.length / 2;
        int vc = k[0].length / 2;
        int w = f.length;
        int h = f[0].length;
        short o[][] = new short[w][h];
        short min = 0;
        short sum = 0;

        for (int x = uc; x < w - uc; x++) {
            for (int y = vc; y < h - vc; y++) {
                min = 255;
                sum = 0;
                for (int v = -vc; v <= vc; v++)
                    for (int u = -uc; u <= uc; u++)
                        if (k[u + uc][v + vc] == 1) {
                            sum = f[x - u][y - v];
                            if (sum < min)
                                min = sum;
                        }
                o[x][y] = min;
            }
        }
        return o;
    }

    public static int numberOfNeighbors(boolean p[]) {
        int n = 0;
        if (p[0]) n++;
        if (p[1]) n++;
        if (p[2]) n++;
        if (p[3]) n++;
        if (p[4]) n++;
        if (p[5]) n++;
        if (p[6]) n++;
        if (p[7]) n++;
        return n;
    }

    public static int numberOf01Transitions(boolean p[]) {
        int n = 0;
        if ((!p[0]) && p[1]) n++;
        if ((!p[1]) && p[2]) n++;
        if ((!p[2]) && p[3]) n++;
        if ((!p[3]) && p[4]) n++;
        if ((!p[4]) && p[5]) n++;
        if ((!p[5]) && p[6]) n++;
        if ((!p[6]) && p[7]) n++;
        if ((!p[7]) && p[0]) n++;
        return n;
    }

    public static float[][] getKv() {
        return kv;
    }

    public static float[][] getKh() {
        return kh;
    }

    public static float[][] getKcross() {
        return kCross;
    }

    public static float[][] getKsquare() {
        return kSquare;
    }

    public static float[][] getKthintop() {
        return kThinTop;
    }

    public static float[][] getKthinbottom() {
        return kThinBottom;
    }

    public static float[][] getKoutline() {
        return kOutline;
    }

    public static short[][] erode(short f[][], float k[][]) {
        int uc = k.length / 2;
        int vc = k[0].length / 2;
        int w = f.length;
        int h = f[0].length;

        short o[][] = new short[w][h];
        short sum = 0;

        for (int x = uc; x < w - uc; x++) {
            for (int y = vc; y < h - vc; y++) {
                sum = 255;
                for (int v = -vc; v <= vc; v++)
                    for (int u = -uc; u <= uc; u++)
                        if (k[u + uc][v + vc] == 1)
                            if (f[x - u][y - v] < sum)
                                sum = f[x - u][y - v];
                o[x][y] = sum;
            }
        }
        return o;
    }
}
