package ip.graphics;

import java.awt.*;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class MouseMovementHandler
        implements MouseMotionListener,
        MouseListener {
    private int w = 10;
    private int h = 5;
    private int x1,y1,x2,y2;

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        Object o = e.getSource();
        if (!(o instanceof Component)) return;
        Component c = (Component) o;
        x1 = x2;
        y1 = y2;
        x2 = e.getX();
        y2 = e.getY();
        c.setLocation(x2, y2);
        c.repaint();
    }

    public void addComponent(Component c) {
        c.addMouseMotionListener(this);
        c.addMouseListener(this);
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        x1 = e.getX();
        y1 = e.getY();
        x2 = -1;
    }
}
