/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package gui.run;

import gui.ClosableJFrame;
import j3d.utils.Java3DExplorerConstants;

import javax.media.j3d.Transform3D;
import javax.swing.*;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3d;
import java.awt.*;
import java.text.NumberFormat;


public abstract class RunTransform3dPanel extends
                                          JPanel implements
                                                 Runnable,
                                                 Java3DExplorerConstants {
    private Transform3D translateTrans = new Transform3D();
    private Transform3D scaleTrans = new Transform3D();
    private Transform3D rotateTrans = new Transform3D();
    private Transform3D refPtInvTrans = new Transform3D();



    // Temporaries that are reused
    private Transform3D tmpTrans = new Transform3D();



    public Transform3D getValue() {

        // now build up the transfomation
        // trans = translate * refPtInv * scale * rotate * refPt;
        tmpTrans.set(translateTrans);
        tmpTrans.mul(refPtInvTrans);
        tmpTrans.mul(scaleTrans);
        tmpTrans.mul(rotateTrans);
        return tmpTrans;
    }


    public RunTransform3dPanel() {
        setLayout(new BorderLayout());
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab(
                "Scaling", new RunVec3dPanel() {
                    public void run() {
                        scaleTrans.setScale(getValue());
                        RunTransform3dPanel.this.run();
                    }
                });
        tabbedPane.addTab(
                "Rotation", new RunVec3dPanel() {
                    public void run() {
                        Vector3d value = getValue();
                        Matrix3d m = new Matrix3d();
                        double d[] = new double[3];
                        value.get(d);
                        Transform3D rx = new Transform3D();
                        Transform3D ry = new Transform3D();
                        Transform3D rz = new Transform3D();
                        m.rotX(d[0]);
                        rx.setRotation(m);
                        m.rotY(d[1]);
                        ry.setRotation(m);
                        m.rotZ(d[2]);
                        rz.setRotation(m);
                        rx.mul(ry);
                        rx.mul(rz);
                        rotateTrans = rx;
                        RunTransform3dPanel.this.run();
                    }
                });
        tabbedPane.addTab(
                "Translation", new RunVec3dPanel() {
                    public void run() {
                        translateTrans.setTranslation(getValue());
                        RunTransform3dPanel.this.run();
                    }
                });


        add(BorderLayout.CENTER, tabbedPane);

    }


    public static void main(String[] args) {

        ClosableJFrame cf = new ClosableJFrame();
        Container c = cf.getContentPane();
        final Transform3DViewPanel view = new Transform3DViewPanel();
        c.add(
                new RunTransform3dPanel() {
                    public void run() {
                        Transform3D value = getValue();
                        view.updateView(value);
                    }
                });

        c.add(view);
        c.setLayout(new FlowLayout());
        cf.setSize(400, 400);
        cf.setVisible(true);

    }
    public static class Transform3DViewPanel extends JPanel{
        Transform3D t3d = new Transform3D();
        Matrix4f m = new Matrix4f();
        JLabel jla[][] = new JLabel[4][4];
        NumberFormat nf = getNumberFormat();
        Transform3DViewPanel(){
            setBorder(BorderFactory.createEtchedBorder());
            setLayout(new GridLayout(4,0,5,5));
            t3d.setIdentity();
            m.setIdentity();
            initLabels();
            updateView(t3d);
        }

        private void initLabels() {

            for (int x = 0; x < jla.length; x++)
                for (int y = 0; y < jla[0].length; y++) {
                    String element = nf.format(m.getElement(x, y));
                    JLabel jLabel = new JLabel(element);
                    jla[x][y] = jLabel;
                    add(jLabel);
                }
        }

        private static NumberFormat getNumberFormat() {
            NumberFormat nf = NumberFormat.getInstance();
            nf.setMaximumFractionDigits(2);
            nf.setMinimumFractionDigits(2);
            nf.setMaximumIntegerDigits(2);
            nf.setMinimumIntegerDigits(1);
            return nf;
        }

        public void updateView(Transform3D t3d) {
            this.t3d = t3d;
            t3d.get(m);
            for (int x=0; x < jla.length; x++)
                for (int y=0; y < jla[0].length; y++){
                    float element = m.getElement(x, y);
                    String s = nf.format(element);
                    if (element >= 0) s = "+"+s;
                    jla[x][y].setText(s);
                }
            repaint();
        }
    }

}
