package gui.run;

import gui.ClosableJFrame;

import javax.swing.*;
import java.awt.*;


public class RunTabbedFrame
        extends ClosableJFrame {
    Container c = getContentPane();
    RunTabController rtc;
    JTabbedPane jtp
            = new JTabbedPane();

    class CheckBoxPanel
            extends JPanel {
        RunTabController rtc;

        CheckBoxPanel(RunTabController _rtc) {
            super(false);
            rtc = _rtc;

            add(new RunCheckBox("Check #[1") {
                public void run() {
                    rtc.println("First Check Box!");
                }
            });
            add(new RunCheckBox("Check #[2") {
                public void run() {
                    rtc.println("check #2");
                }
            });
            add(new RunCheckBox("Check #[3") {
                public void run() {
                    rtc.println("check #3");
                }
            });

        }
    }

    class MenuBarPanel
            extends javax.swing.JPanel {
        RunTabController rtc;
        JMenuBar bar
                = new JMenuBar();
        JMenu menu
                = new javax.swing.JMenu("Checkable");

        MenuBarPanel(RunTabController _rtc) {
            super(false);
            rtc = _rtc;
            bar.add(menu);
            menu.add(new RunCheckBoxMenuItem("[Top Check{alt shift T}") {
                public void run() {
                    rtc.println("topCheck!");
                }
            });
            menu.add(new RunCheckBoxMenuItem("[Check Me{alt shift C}") {
                public void run() {
                    rtc.println("Check box menu item!!");
                }
            });
            menu.add(new RunCheckBoxMenuItem("[Type me{typed A}") {
                public void run() {
                    rtc.println("Check box menu item!!");
                }
            });
            add(bar);
        }
    }

    class RunButtonPanel
            extends javax.swing.JPanel {
        gui.run.RunTabController rtc;

        RunButtonPanel(gui.run.RunTabController rtc) {
            super(false);
            this.rtc = rtc;
            add(new RunButton("[Left") {
                public void run() {
                    System.out.println(getText());
                }
            });
            add(new RunButton("[Right") {
                public void run() {
                    System.out.println(getText());
                }
            });
            add(new RunButton("[Quit") {
                public void run() {
                    setVisible(false);
                }
            });
        }
    }

    public RunTabbedFrame(RunTabController rtc) {
        super("gui.run tab");
        this.rtc = rtc;
        setSize(200, 200);
        jtp.addTab("[Button Panel",
                null,
                new RunButtonPanel(rtc),
                "Quit Button is here!");

        jtp.addTab("[CheckBox Panel",
                null,
                new CheckBoxPanel(rtc),
                "Examples of JCheckBox");

        jtp.addTab("[Menu Bar Panel", null,
                new MenuBarPanel(rtc),
                "Examples of JMenuBar");

        jtp.addTab("[Label Panel", null,
                new LabelPanel(),
                "Examples of JLabel");
        ShortcutUtils.addShortcut(jtp);
        c.add(jtp);
        c.setLayout(new GridLayout(1, 1));
        setVisible(true);
    }

    class LabelPanel extends javax.swing.JPanel {
        LabelPanel() {
            add(new RunLabel("I'm [Label 1     "));
            add(new JLabel("I'm Label 2     "));
            add(new JLabel("I'm Label 3"));
        }
    }
}