package gui.run;

/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */

import gui.ClosableJFrame;

import javax.swing.*;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.*;

public abstract class RunSpinner extends JSpinner
        implements Runnable, ChangeListener {
    private static final int PAGE_SIZE = 5;
    public RunSpinner(SpinnerModel sm) {
        setModel(sm);
        sm.addChangeListener(this);
        registerKeyboardAction(new PgUpMover(),
                KeyStroke.getKeyStroke(KeyEvent.VK_PAGE_UP, 0),
                JComponent.WHEN_IN_FOCUSED_WINDOW);
        registerKeyboardAction(new PgDnMover(),
                KeyStroke.getKeyStroke(KeyEvent.VK_PAGE_DOWN, 0),
                JComponent.WHEN_IN_FOCUSED_WINDOW);
        registerKeyboardAction(new HomeMover(),
                KeyStroke.getKeyStroke(KeyEvent.VK_HOME, 0),
                JComponent.WHEN_IN_FOCUSED_WINDOW);
        registerKeyboardAction(new EndMover(),
                KeyStroke.getKeyStroke(KeyEvent.VK_END, 0),
                JComponent.WHEN_IN_FOCUSED_WINDOW);


    }
    public SpinnerNumberModel getNumberModel() {
        return (SpinnerNumberModel) getModel();
    }


    public void stateChanged(ChangeEvent event) {
        run();
    }
    class PgUpMover implements ActionListener {

        SpinnerNumberModel nm = getNumberModel();
        public void actionPerformed(ActionEvent e) {
            Integer newValue = new Integer(nm.getNumber().intValue() +
                    PAGE_SIZE * nm.getStepSize().intValue());

            Comparable maximum = nm.getMaximum();
            if (maximum != null && maximum.compareTo(newValue) < 0)
                return;

            nm.setValue(newValue);
        }
    }
    class PgDnMover implements ActionListener {
        SpinnerNumberModel nm = getNumberModel();
        public void actionPerformed(ActionEvent e) {
            Integer newValue = new Integer(nm.getNumber().intValue() -
                    PAGE_SIZE * nm.getStepSize().intValue());

            Comparable minimum = nm.getMinimum();
            if (minimum != null && minimum.compareTo(newValue) > 0)
                return;
            nm.setValue(newValue);
        }
    }

    /**
     * Moves Spinner's value to minimum
     */
    class HomeMover implements ActionListener {
        SpinnerNumberModel nm = getNumberModel();
        public void actionPerformed(ActionEvent e) {
            Comparable minimum = nm.getMinimum();
            if (minimum != null)
                nm.setValue(minimum);
        }
    }



    class EndMover implements ActionListener {
        SpinnerNumberModel nm = getNumberModel();
        public void actionPerformed(ActionEvent e) {
            Comparable maximum = nm.getMaximum();
            if (maximum != null)
                nm.setValue(maximum);
        }
    }
    public static void main(String args[]) {
        ClosableJFrame cf = new ClosableJFrame();
        final Container contentPane = cf.getContentPane();
        contentPane.add(new RunSpinner(new SpinnerNumberModel()) {
            public void run() {
                System.out.println(getValue());
            }
        });

        cf.setSize(400, 75);
        cf.setVisible(true);

    }
}
