/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package gui.run;


import gui.ClosableJFrame;
import gui.In;

import javax.swing.*;
import java.awt.*;


public abstract class RunFindPanel
        extends JPanel implements Runnable {

    private FindBean findBean = FindBean.restore();

    public RunFindPanel() {

        init();
    }

    private void init() {
        setLayout(new BorderLayout());
        add(
                new RunTextField(findBean.getFindString(), 20) {
                    public void run() {
                        findBean.setFindString(getText());

                    }
                }, BorderLayout.NORTH);
        add(getCheckboxPanel(), BorderLayout.CENTER);
        add(getButtonPanel(), BorderLayout.SOUTH);

    }

    private JPanel getCheckboxPanel() {
        JPanel jp = new JPanel();
        jp.setBorder(BorderFactory.createEtchedBorder());
        jp.setLayout(new GridLayout(2, 0));
        jp.add(
                new RunCheckBox("In Name", findBean.isInName()) {
                    public void run() {
                        findBean.setInName(isSelected());
                    }
                });
        jp.add(
                new RunCheckBox("In Address", findBean.isInAddress()) {

                    public void run() {
                        findBean.setInAddress(isSelected());
                    }
                });
        jp.add(
                new RunCheckBox("In Info.", findBean.isInInfo()) {
                    public void run() {
                        findBean.setInInfo(isSelected());
                    }
                });
        jp.add(
                new RunCheckBox("In Phone", findBean.isInPhone()) {
                    public void run() {
                        findBean.setInPhone(isSelected());
                    }
                });
        return jp;
    }

    private JPanel getButtonPanel() {
        JPanel jp = new JPanel();

        jp.setLayout(new FlowLayout());
        jp.add(
                new RunButton("[Help") {
                    public void run() {
                        In.message("Hello world");
                    }
                });
        jp.add(
                new RunButton("[Find") {
                    public void run() {
                        findBean.save();
                        RunFindPanel.this.run();
                    }
                });
        return jp;
    }


    public FindBean getFindBean() {
        return findBean;
    }


    public static void main(String[] args) {
        ClosableJFrame cf = new ClosableJFrame();
        Container c = cf.getContentPane();
        c.add(
                new RunFindPanel() {
                    public void run() {
                        System.out.println(getFindBean());
                    }
                });
        cf.setSize(200, 200);
        cf.setVisible(true);
    }


}