package gui.run;

import utils.SystemUtils;

import javax.swing.*;
import java.io.*;
import java.util.prefs.Preferences;

/**
 * This class displays a dialog box that allows
 * the user can select a directory.
 */
public abstract class RunDirectoryChooser implements Runnable {
    private static String key = "DirectoryChooser";
    private String directory;

    private static String defaultDir = restore();

    /**
     * Display a dialog using the specified title.
     */
    public RunDirectoryChooser(String title) {

        getDirectoryUsingJFileChooser(title);
        run();
    }

    private void getDirectoryUsingJFileChooser(String title) {
        SystemUtils.setSystemLookAndFeel();
        JFileChooser chooser = new JFileChooser();
        if (defaultDir != null)
            chooser.setCurrentDirectory(new File(defaultDir));
        chooser.setDialogTitle(title);
        chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        chooser.setApproveButtonText("Select");
        if (chooser.showOpenDialog(null) == JFileChooser.APPROVE_OPTION) {
            File dir = chooser.getCurrentDirectory();
            File file = chooser.getSelectedFile();
            directory = dir.getPath() + File.separator;
            defaultDir = directory;
            directory += file.getName() + File.separator;
        }
    }

    public static void main(String[] args) {
        new RunDirectoryChooser("select a directory") {
            public void run() {
                System.out.println(getDirectory());
            }
        };

    }

    /**
     * Returns the directory selected by the user.
     */
    public File getDirectory() {
        try {
            save();
        } catch (IOException e) {
        }
        if (directory == null) return null;
        return new File(directory);
    }

    /**
     * saves the properties to the Preferences of the userRoot
     */
    public void save() throws IOException {
        if (directory == null) return;
        Preferences p = Preferences.userRoot();
        ByteArrayOutputStream baos = new
                ByteArrayOutputStream();
        ObjectOutputStream oos = new
                ObjectOutputStream(baos);
        oos.writeObject(directory);
        baos.close();
        p.putByteArray(key, baos.toByteArray());
    }


    /**
     * restores the properties from the preference in the user root.
     */
    public static String restore() {
        try {
            Preferences p = Preferences.userRoot();
            byte b [] = p.getByteArray(key, null);
            if (b == null)
                return new String();
            ByteArrayInputStream bais = new
                    ByteArrayInputStream(b);
            ObjectInputStream ois = new
                    ObjectInputStream(bais);
            Object o = ois.readObject();
            bais.close();
            return (String) o;
        } catch (IOException e) {
            //e.printStackTrace();
        } catch (ClassNotFoundException e) {
            // e.printStackTrace();
        }
        return new String();
    }
}
