/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package gui.run;


import gui.ClosableJFrame;

import javax.swing.*;
import java.awt.*;


public abstract class RunDelimiterPanel
        extends JPanel implements Runnable {

    private DelimiterBean delimiterBean = DelimiterBean.restore();
    RadioTextPanel recordPanel = new RadioTextPanel("Record Delimiter");
    RadioTextPanel linePanel = new RadioTextPanel("Line Delimiter");
    RadioTextPanel fieldPanel = new RadioTextPanel("Field Delimiter");

    public RunDelimiterPanel() {
        setLayout(new GridLayout(0, 1));
        add(linePanel);
        add(fieldPanel);
        add(recordPanel);
        add(getButtonPanel());
        setFromBean();
    }

    public void setFromBean() {
        linePanel.setDelimiter(delimiterBean.getLineDelimiter());
        fieldPanel.setDelimiter(delimiterBean.getFieldDelimiter());
        recordPanel.setDelimiter(delimiterBean.getRecordDelimiter());
    }
    public void setBean(){
        delimiterBean.setLineDelimiter(linePanel.getDelimiter());
        delimiterBean.setFieldDelimiter(fieldPanel.getDelimiter());
        delimiterBean.setRecordDelimiter(recordPanel.getDelimiter());
    }


    private JPanel getButtonPanel() {
        JPanel jp = new JPanel();

        jp.setLayout(new FlowLayout());
        jp.add(new RunButton("Normal") {
            public void run() {
                delimiterBean.setToDefault();
                setFromBean();
            }
        });
        jp.add(new RunButton("OK") {
            public void run() {
                setBean();
                delimiterBean.save();
                RunDelimiterPanel.this.run();
            }
        });
        return jp;
    }


    public DelimiterBean getDelimiterBean() {
        return delimiterBean;
    }


    public static void main(String[] args) {
        ClosableJFrame cf = new ClosableJFrame();
        Container c = cf.getContentPane();
        c.add(new RunDelimiterPanel() {
            public void run() {
                System.out.println(getDelimiterBean());
            }
        });
        cf.pack();
        cf.setVisible(true);
    }


}