package gui.run;

import gui.ClosableJFrame;

import java.awt.*;
import java.awt.event.ActionEvent;

/**
 * DocJava, Inc. http://www.docjava.com
 * Programmer: dlyon Date: Mar 3, 2004 Time:
 * 7:52:32 PM
 */
public abstract class RunColorToggleButton
        extends RunButton {
    private boolean selected = false;

    public static void main(String[] args) {
        ClosableJFrame cf = new ClosableJFrame();
        Container c = cf.getContentPane();
        c.setLayout(new FlowLayout());
        c.add(new RunColorToggleButton("[ok") {
            public void run() {
                System.out.println(getText() +
                        "isSlected=" + isSelected());
            }
        });

        c.add(new RunColorToggleButton("[cancel") {
            public void run() {
                System.out.println(getText() +
                        "isSlected=" + isSelected());
            }
        });
        cf.setSize(200, 200);
        cf.show();
    }

    public void setSelected(boolean b) {
        if (b == selected) return;
        selected = b;
        toggleColor();
    }

    public void actionPerformed(ActionEvent e) {
        selected = !selected;
        toggleColor();
        super.actionPerformed(e);
    }

    private void toggleColor() {
        Color foreground = getForeground();
        setForeground(getBackground());
        setBackground(foreground);
    }

    public boolean isSelected() {
        return selected;
    }

    public RunColorToggleButton(String s) {
        super(s);
        setBackground(Color.red);
        setForeground(Color.green);
    }


}
