package gui.run;

import gui.ClosableJFrame;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;


public abstract class RunCheckBox extends
        JCheckBox
        implements
        ItemListener,
        Runnable {
    public RunCheckBox(String label) {
        this(label, false);
        addItemListener(this);
    }
    public RunCheckBox(boolean b) {
        this("", b);
        addItemListener(this);
    }
    public RunCheckBox(Icon i, boolean b) {
        super(i, b);
        addItemListener(this);
    }

    public RunCheckBox(String s, boolean b) {
        super(s, b);
        addItemListener(this);
        ShortcutUtils.addShortcut(this);
    }

    public RunCheckBox(Icon i) {
        super(i);
        addItemListener(this);
    }

    public RunCheckBox() {
        addItemListener(this);
    }

    public void itemStateChanged(ItemEvent e) {
        run();
    }

    public static void main(String[] args) {
        testRunCheckBox();
    }
    public static void testRunCheckBox() {
        ClosableJFrame cf = new ClosableJFrame("RunCheckBox");
        Container c = cf.getContentPane();
        c.add(new RunCheckBox("[RunCheckBox") {
            public void run() {
                System.out.println(getText() + "=" +
                        isSelected());
            }
        });
        c.add(new RunCheckBox("[CheckMe, Baby!") {
            public void run() {
                System.out.println(getText() + "=" +
                        isSelected());
            }
        });
        c.setLayout(new java.awt.GridLayout(4, 0));
        cf.setSize(200, 200);
        cf.setVisible(true);

    }
}