package gui.run;

import futils.FileList;
import gui.ClosableJFrame;
import gui.layouts.Alignable;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public abstract class RunButton extends JButton
        implements ActionListener, Alignable,
        Runnable {
    public RunButton(String label) {
        this(label, null);
    }
   
    private int alignment = Alignable.CENTER;

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    public int getAlignment() {
        return alignment;
    }

    public RunButton(String l, Icon i) {
        super(l, i);
        addActionListener(this);
        ShortcutUtils.addShortcut(this);
        setToolTipText(getText());
    }

    public RunButton(Icon i) {
        this(null, i);
    }

    public RunButton() {
        this(null, null);
    }

    public void actionPerformed(ActionEvent e) {
        run();
    }

    public static void main(String args[]) {
        // anonymous inner class
        // That uses the command pattern
        // also uses adapter pattern
        // since the normal
        // requires an
        // actionListener-
        // actionPerformed(ActionEvent e)
        // now we just need a run method.
        // Semantics for the runButton now include
        // an implicit metaChar='['


        final ClosableJFrame cf =
                new ClosableJFrame("OK-CANCEL Frame");
        final Container c = cf.getContentPane();
        c.setLayout(new BoxLayout(c, BoxLayout.PAGE_AXIS));
        c.add(new RunButton("[boxLayout-pageAxis") {
            public void run() {
                c.setLayout(new BoxLayout(c, BoxLayout.PAGE_AXIS));
                cf.pack();
            }
        });
        c.add(new RunButton("box[Layout-LINE_AXIS") {
            public void run() {
                c.setLayout(new BoxLayout(c, BoxLayout.LINE_AXIS));
                cf.pack();
            }
        });
        c.add(new RunButton("[boxLayout-X_AXIS") {
            public void run() {
                c.setLayout(new BoxLayout(c, BoxLayout.X_AXIS));
                cf.pack();
            }
        });
        c.add(new RunButton("kill me") {
            public void run() {
                System.exit(0);
            }
        });
        c.add(new RunButton("[boxLayout-Y_AXIS") {
            public void run() {
                BoxLayout boxLayout = new BoxLayout(c, BoxLayout.Y_AXIS);
                c.setLayout(boxLayout);
                cf.pack();
            }
        });
        c.add(new RunButton("[FlowLayout") {
            public void run() {
                c.setLayout(new FlowLayout());
                cf.pack();
            }
        });
        c.add(new RunButton("[GridLayout(2,0)") {
            public void run() {
                c.setLayout(new GridLayout(2, 0));
                cf.pack();
            }
        });
        c.add(new RunButton("[GridLayout(1,0)") {
            public void run() {
                c.setLayout(new GridLayout(1, 0));
                cf.pack();
            }
        });
        c.add(new RunButton("[GridLayout(3,0)") {
            public void run() {
                c.setLayout(new GridLayout(3, 0));
                cf.pack();
            }
        });
        c.add(Box.createRigidArea(new Dimension(50, 50)));
        c.add(new RunButton("[exit") {
            public void run() {
                cf.hide();
                System.exit(0);
            }
        });
        c.add(new RunButton("[delete all class files!") {
            public void run() {
                FileList fl = new FileList();
                fl.deleteAllClassFiles();
            }
        });
        cf.setSize(200, 200);
        cf.show();
    }
}