package gui.run;

import javax.swing.*;

/**
 * Created by IntelliJ IDEA.
 * User: dlyon
 * Date: Apr 20, 2005
 * Time: 7:21:49 PM
 * Copyright DocJava, 2005
 */
class RadioTextPanel extends JPanel {
    private String delimiter = "";
    private RunRadio rb1 = new RunRadio("tab") {
        public void run() {
            delimiter = "\t";
        }
    };
    private RunRadio rb2 = new RunRadio("cr") {
        public void run() {
            delimiter = "\n";
        }
    };
    private final RunTextField tf = new RunTextField(4){
        public void run(){
            delimiter = tf.getText();
        }
    };
    private RunRadio rb3 = new RunRadio("") {
        public void run() {
            delimiter = tf.getText();
        }
    };


    RadioTextPanel( String title) {

        setBorder(BorderFactory.createTitledBorder(title));
        add(rb1);
        add(rb2);
        add(rb3);
        add(tf);
        ButtonGroup bg = new ButtonGroup();
        bg.add(rb1);
        bg.add(rb2);
        bg.add(rb3);
    }

    public String getDelimiter() {
        return delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
        tf.setText(delimiter);
        if (delimiter.equals("\t")) {
            rb1.setSelected(true);
            return;
        }
        if (delimiter.equals("\n")) {
            rb2.setSelected(true);
            return;
        }
        rb3.setSelected(true);
    }
}
