/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package gui.run;

import utils.CompactJava;

import java.io.*;
import java.util.prefs.Preferences;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Apr 3, 2005
 * <p/>
 * Time: 4:40:58 PM
 */
public class FindBean implements Serializable {
    private String findString = "";
    private boolean inName = true;
    private boolean inAddress = true;
    private boolean inInfo = true;
    private boolean inPhone = true;
    private static String key = "FindBean";

    public FindBean() {

    }


    public String getFindString() {
        return findString;
    }

    public void setFindString(String findString) {
        this.findString = findString;
    }

    public boolean isInName() {
        return inName;
    }

    public void setInName(boolean inName) {
        this.inName = inName;
    }

    public boolean isInAddress() {
        return inAddress;
    }

    public void setInAddress(boolean inAddress) {
        this.inAddress = inAddress;
    }

    public boolean isInInfo() {
        return inInfo;
    }

    public void setInInfo(boolean inInfo) {
        this.inInfo = inInfo;
    }

    public boolean isInPhone() {
        return inPhone;
    }

    public void setInPhone(boolean inPhone) {
        this.inPhone = inPhone;
    }
    public String toString() {
          return CompactJava.toXml(this);
      }

    /**
     * saves the properties to the Preferences of the userRoot
     */
    public void save() {
        try {
            Preferences p = Preferences.userRoot();
            ByteArrayOutputStream baos = new
                    ByteArrayOutputStream();
            ObjectOutputStream oos = new
                    ObjectOutputStream(baos);
            oos.writeObject(this);
            baos.close();
            p.putByteArray(key, baos.toByteArray());
        } catch (IOException e) {
            e.printStackTrace();
        }
    }


    /**
     * restores the properties from the preference in the user root.
     */
    public static FindBean restore() {
        try {
            Preferences p = Preferences.userRoot();
            byte b [] = p.getByteArray(key, null);
            if (b == null)
                return new FindBean();
            ByteArrayInputStream bais = new
                    ByteArrayInputStream(b);
            ObjectInputStream ois = new
                    ObjectInputStream(bais);
            Object o = ois.readObject();
            bais.close();
            return (FindBean) o;
        } catch (IOException e) {
            //e.printStackTrace();
        } catch (ClassNotFoundException e) {
            // e.printStackTrace();
        }
        return new FindBean();
    }
}
