/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package gui.run;

import java.io.*;
import java.util.prefs.Preferences;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Apr 3, 2005
 * <p/>
 * Time: 4:40:58 PM
 */
public class DelimiterBean implements Serializable {
    private String lineDelimiter = "\t";
    private String fieldDelimiter = ",";
    private String recordDelimiter = "\n";

    private static String key = "DelimiterBean";

    public DelimiterBean() {

    }

    public void setToDefault() {
        lineDelimiter = "\t";
        fieldDelimiter = ",";
        recordDelimiter = "\n";
    }

    /**
     * saves the properties to the Preferences of the userRoot
     */
    public void save() {
        try {
            Preferences p = Preferences.userRoot();
            ByteArrayOutputStream baos = new
                    ByteArrayOutputStream();
            ObjectOutputStream oos = new
                    ObjectOutputStream(baos);
            oos.writeObject(this);
            baos.close();
            p.putByteArray(key, baos.toByteArray());
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        return "line="+lineDelimiter+" field="+ fieldDelimiter+" record="+recordDelimiter;
    }

  public static DelimiterBean restore() {
        try {
            Preferences p = Preferences.userRoot();
            byte b [] = p.getByteArray(key, null);
            if (b == null)
                return new DelimiterBean();
            ByteArrayInputStream bais = new
                    ByteArrayInputStream(b);
            ObjectInputStream ois = new
                    ObjectInputStream(bais);
            Object o = ois.readObject();
            bais.close();
            return (DelimiterBean) o;
        } catch (IOException e) {
            //e.printStackTrace();
        } catch (ClassNotFoundException e) {
            // e.printStackTrace();
        }
        return new DelimiterBean();
    }

    public String getLineDelimiter() {
        return lineDelimiter;
    }

    public void setLineDelimiter(String lineDelimiter) {
        this.lineDelimiter = lineDelimiter;
    }

    public String getFieldDelimiter() {
        return fieldDelimiter;
    }

    public void setFieldDelimiter(String fieldDelimiter) {
        this.fieldDelimiter = fieldDelimiter;
    }

    public String getRecordDelimiter() {
        return recordDelimiter;
    }

    public void setRecordDelimiter(String recordDelimiter) {
        this.recordDelimiter = recordDelimiter;
    }
}
