/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package gui.layouts;

import gui.ClosableJFrame;
import gui.run.RunButton;
import gui.run.RunLabel;

import javax.swing.*;
import java.awt.*;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Mar 17, 2005
 * <p/>
 * Time: 4:24:00 PM
 */
public class VerticalFlowLayout implements LayoutManager {
    private int vgap = 0;
    private int hgap = 5;

    /**
     * VerticalFlowLayout constructor comment.
     */
    public VerticalFlowLayout() {
    }

    /**
     * VerticalFlowLayout constructor comment.
     */
    public VerticalFlowLayout(int vgap, int hgap) {
        if (vgap < 0) {
            this.vgap = 0;
        } else {
            this.vgap = vgap;
        }
        if (hgap < 0) {
            this.hgap = 0;
        } else {
            this.hgap = hgap;
        }
    }

    /**
     * addLayoutComponent method comment.
     */
    public void addLayoutComponent(String name, Component comp) {
    }

    /**
     * layoutContainer method comment.
     */
    public void layoutContainer(Container parent) {
        Insets insets = parent.getInsets();
        int w = parent.getSize().width - insets.left - insets.right;
        int h = parent.getSize().height - insets.top - insets.bottom;
        int numComponents = parent.getComponentCount();
        if (numComponents == 0) {
            return;
        }
        int y = insets.top;
        int x = insets.left;
        int hmax = 0;
        for (int i = 0; i < numComponents; ++i) {
            Component c = parent.getComponent(i);
            if (c.isVisible()) {
                Dimension d = c.getMinimumSize();
                c.setBounds(x, y, d.width, d.height);
                y += d.height + vgap;
                if (d.width > hmax)
                    hmax = d.width;
                if (y + d.height > h) {
                    y = vgap; // vertical carrage return
                    x = x + hgap + hmax;    // shove over in the x direction
                }
            }
        }
    }

    /**
     * minimumLayoutSize method comment.
     */
    public Dimension minimumLayoutSize(Container parent) {
        layoutContainer(parent);
        int w = 0;
        int h = 0;
        int numComponents = parent.getComponentCount();
        if (numComponents == 0) {
            return new Dimension(0, 0);
        }
        for (int i = 0; i < numComponents; ++i) {
            Component c = parent.getComponent(i);
            if (c.isVisible()) {
                Dimension d = c.getMinimumSize();

                h += d.height + vgap;
                w += d.width + hgap;
            }
        }
        return new Dimension(w, h);
    }

    public Dimension preferredLayoutSize(Container parent) {
        return minimumLayoutSize(parent);
    }

    public void removeLayoutComponent(Component comp) {
    }

    public static void main(String[] args) {
        testLayout();

    }

    private static void testLayout() {
        ClosableJFrame cj = new ClosableJFrame("20700 Records");
        Container c = cj.getContentPane();
        c.setLayout(new BorderLayout());

        c.add(getLabelPanel(), BorderLayout.CENTER);
        c.add(getButtonControlPanel(),BorderLayout.SOUTH);
        c.add(getLetterPanel(),BorderLayout.EAST);
        Dimension d = c.getMinimumSize();
        int m = (int)Math.sqrt((d.width*d.height))/4;
        cj.setSize(m,m);
        cj.show();
    }

    private static JPanel getButtonControlPanel() {
        JPanel jp = new JPanel();

        jp.setLayout(new FlowLayout());
        jp.add(new RunButton("find") {
            public void run() {

            }
        });
        jp.add(new RunButton("prev") {
            public void run() {

            }
        });
        jp.add(new RunButton("next") {
            public void run() {

            }
        });
        jp.add(new RunButton("edit") {
            public void run() {

            }
        });
        return jp;
    }
       private static JPanel getLetterPanel() {
        JPanel jp = new JPanel();
        jp.setLayout(new GridLayout(0,1));
        for (int j = 0; j < 26; j++)
                jp.add(new RunButton((char)(('a'+j))+"") {
                    public void run() {
                        System.out.println(getText());
                    }
                });
        return jp;
    }
    private static JPanel getLabelPanel() {
        JPanel jp = new JPanel();

        jp.setLayout(new VerticalFlowLayout(0, 9));
        for (int j = 0; j < 30; j++)
            for (int i = 0; i < 3; i++) {
                jp.add(new RunLabel("Test#" + j + "," + i) {

                    public void run() {
                        System.out.println(getText());
                    }
                });
            }
        return jp;
    }

    public static void test1() {
        ClosableJFrame cj = new ClosableJFrame();
        Container c = cj.getContentPane();
        c.setLayout(new VerticalFlowLayout(0, 5));
        for (int j = 0; j < 30; j++)
            for (int i = 0; i < 10; i++) {
                c.add(new RunLabel("Test#" + j + "," + i) {

                    public void run() {
                        System.out.println(getText());
                    }
                });
            }
        cj.pack();
        cj.validate();
        cj.show();
    }
}
