package gui.keyboard;

import java.awt.event.KeyEvent;


final class KeyController implements
        java.awt.event.KeyListener {
    public void keyPressed(final java.awt.event.KeyEvent e) {
        final char keyChar = e.getKeyChar();
        final int keyCode = e.getKeyCode();
        final String keyText = KeyEvent.getKeyText(keyCode);

        final int modifiers = e.getModifiers();
        final String modifierText = KeyEvent.getKeyModifiersText(modifiers);


        System.out.println("keyChar=" + (int) keyChar);
        System.out.println("keyText=" + keyText);
        System.out.println("modifiers=" + modifiers);
        System.out.println("modifierText=" + modifierText);

        System.out.println("processModifiers=" + processModifiers(e));


    }

    private static String processModifiers(final java.awt.event.KeyEvent e) {
        final int modifiers = e.getModifiers();
        final int keyCode = e.getKeyCode();
        final String keyText = KeyEvent.getKeyText(keyCode);

        String s = "";
        if ((modifiers & java.awt.event.InputEvent.META_MASK) != 0)
            s = s + "M-";

        if ((modifiers & java.awt.event.InputEvent.CTRL_MASK) != 0)
            s = s + "^-";

        if ((modifiers & java.awt.event.InputEvent.ALT_MASK) != 0)
            s = s + "A-";

        if ((modifiers & java.awt.event.InputEvent.SHIFT_MASK) != 0)
            s = s + "Shift-";

        return s + keyText;
    }

    public void keyTyped(final java.awt.event.KeyEvent e) {
        System.out.println(e);
    }

    public void keyReleased(final java.awt.event.KeyEvent e) {
        System.out.println(e);
    }
}