/*
 * @author Douglas A. Lyon
 * @version  Oct 31, 2002.10:43:22 AM
 */
package gui.html;

import javax.servlet.http.HttpSession;
import java.io.Serializable;

public class LoginForm
        implements Serializable {
    private String userId = null;
    private String passWord = null;
    private HtmlSynthesizer hs
            = new HtmlSynthesizer();

    public void saveToSession(HttpSession s) {
        s.putValue("login", this);
    }

    public static LoginForm getFromSession(HttpSession s) {
        Object o = s.getValue("login");
        if (o == null) return null;
        if (o instanceof LoginForm)
            return (LoginForm) o;
        return null;
    }

    public String toString() {
        return
                hs.getHtml(
                        hs.getTitle("login form")
                + hs.getBody(
                        hs.getForm("ProcessLogin",
                                "GET",
                                hs.getH1("please login")
                + hs.getP("Uid:"
                + hs.getTextField("uid"))
                + hs.getP("password:"
                + hs.getPassField("pw"))
                + hs.getSubmit()
                        )
                ));
    }

    public static void main(String args[]) {
        LoginForm lf = new
                LoginForm();
        System.out.println(lf);
        HtmlViewer hv = new HtmlViewer();
        hv.setString(lf.toString());
    }
}
