package gui.dialogs;

import gui.run.RunButton;
import gui.run.RunCheckBox;

import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.BorderFactory;
import java.util.Vector;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.FlowLayout;
import java.awt.BorderLayout;

/**
 * DocJava, Inc.
 * http://www.docjava.com
 * Programmer: dlyon
 * Date: Sep 15, 2004
 * Time: 5:14:32 PM
 */
public class SelectorDialog {
    private static RunCheckBox getRunCheckBox(String s) {
        return new RunCheckBox(s) {
            public void run() {

            }
        };
    }

    public static void markAll(RunCheckBox cb[]) {
        for (int i = 0; i < cb.length; i++)
            cb[i].setSelected(true);
    }

    public static void unmarkAll(RunCheckBox cb[]) {
        for (int i = 0; i < cb.length; i++)
            cb[i].setSelected(false);
    }

    private static RunCheckBox[] getRunCheckBoxes(String s[]) {
        Vector v = new Vector();
        for (int i = 0; i < s.length; i++)
            v.addElement(getRunCheckBox(s[i]));
        RunCheckBox checkBoxes[] = new RunCheckBox[v.size()];
        v.copyInto(checkBoxes);
        return checkBoxes;
    }

    public static String[] getStringSelectorDialog(Object oa[]){
        String s[] = new String[oa.length];
        for (int i=0; i < oa.length; i++)
            s[i] = oa[i].toString();
        return getStringSelectorDialog(s);
    }

    /**
     * A string selector dialog presents a list of checkboxes
     * for the user to select. This works atomically, blocking
     * the invokers thread.
     * @param selectStrings    an array from which to choose
     * @return  a list of selected strings
     */
    public static String[] getStringSelectorDialog(String selectStrings[]) {
        JDialog jd = new JDialog();
        Container c = jd.getContentPane();
        jd.setModal(true);
        final RunCheckBox checkBoxes[] = getRunCheckBoxes(selectStrings);
        JPanel checkBoxPanel = new JPanel();
        for (int i = 0; i < checkBoxes.length; i++)
            checkBoxPanel.add(checkBoxes[i]);
        checkBoxPanel.setLayout(new GridLayout(0, 1));
        JScrollPane jsp = new JScrollPane(checkBoxPanel);

        JPanel buttonPanel = new JPanel();
        buttonPanel.add(new RunButton("[Mark All") {
            public void run() {
                markAll(checkBoxes);
            }
        });
        buttonPanel.add(new RunButton("[Unmark All") {
            public void run() {
                unmarkAll(checkBoxes);
            }
        });
        buttonPanel.setLayout(new FlowLayout());
        c.setLayout(new BorderLayout());
        c.add(jsp, BorderLayout.CENTER);
        c.add(buttonPanel, BorderLayout.SOUTH);
        jsp.setBorder(BorderFactory.createEtchedBorder());
        jd.setSize(200, 200);
        jd.setVisible(true);
        return getMarkedCheckBoxLabels(checkBoxes);
    }

      private static String[] getMarkedCheckBoxLabels(RunCheckBox rcb[]) {
        Vector v = new Vector();
        for (int i = 0; i < rcb.length; i++)
            if (rcb[i].isSelected())
                v.addElement(rcb[i].getText());
        String s[] = new String[v.size()];
        v.copyInto(s);
        return s;
    }

    private static String[] getTestStrings() {
        Vector v = new Vector();
        for (int i = 0; i < 90; i++)
            v.addElement("checkbox#" + i);
        final String checkBoxes[] = new String[v.size()];
        v.copyInto(checkBoxes);
        return checkBoxes;
    }

    public static void main(String args[]) {
        testStringSelectorDialog();
    }

    private static void testStringSelectorDialog() {
        String[] testStrings = getTestStrings();
        String[] s = getStringSelectorDialog(testStrings);

        utils.Print.print(s);
    }
}
