package gui.dialogs;

import gui.ClosableJFrame;

import javax.swing.*;
import java.awt.*;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Nov 24, 2004
 * <p/>
 * Time: 9:33:06 AM
 */
public class ProgressDialog extends ClosableJFrame {
    final JProgressBar jp = new JProgressBar();
    final JLabel jl = new JLabel("% done=" + 0);
    Container c = getContentPane();
    private String units = " bytes transferred";

    public void setIndeterminate(boolean b) {
        jp.setIndeterminate(b);
    }

    public ProgressDialog() {
        c.setLayout(new GridLayout(0, 1));
        c.add(jp);
        c.add(jl);
        jp.setMinimum(0);
        jp.setMaximum(100);
    }

    public void incrementValue(int i) {
        setAmountDone(jp.getValue() + i);
    }

    public void setAmountDone(int amountDone) {
        jp.setValue(amountDone);
        jl.setText(amountDone + units);
        repaint();
    }

    public void setUnits(String units) {
        this.units = units;
    }

    public void setText(String s) {
        jl.setText(s);
        jp.setValue(0);
    }

    public Dimension getPreferredSize() {
        return new Dimension(100, 100);
    }

    public Dimension getMinimumSize() {
        return getPreferredSize();
    }

    public static void main(String[] args) {
        ProgressDialog pd = new ProgressDialog();
        pd.setSize(200, 200);
        pd.setIndeterminate(true);
        //pd.setMinimum(0);
        //pd.setMaximum(100);
        pd.show();
        for (int i = 0; i <= 100; i++) {
            pd.setText("i=" + i);
            pd.setAmountDone(i);
            ProgressDialog.sleep();
        }
    }

    public static void sleep() {
        try {
            Thread.sleep(25);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private static ProgressDialog pd = new ProgressDialog();

    public static ProgressDialog getInstance() {
        return pd;
    }

    public void setMinimum(int i) {
        jp.setMinimum(i);
    }

    public void setMaximum(int i) {
        jp.setMaximum(i);
    }
}
