package graphics.raytracers.tracer.geometry;


final public class Ray3d {
    private Vector3d startPoint, direction;

    public Ray3d(Vector3d pnt, Vector3d dir) {
        startPoint = new Vector3d(pnt.getX(), pnt.getY(), pnt.getZ());
        direction = new Vector3d(dir.getX(), dir.getY(), dir.getZ());
        direction.normalize();
    }

    public Ray3d() {
        startPoint = new Vector3d();
        direction = new Vector3d();
    }

    public Vector3d point(double t) {
        return new Vector3d(startPoint.getX() + direction.getX() * t, startPoint.getY() + direction.getY() * t, startPoint.getZ() + direction.getZ() * t);
    }

    public String toString() {
        return "{" + startPoint.toString() + " -> " + direction.toString() + "}";
    }

    public Vector3d getStartPoint() {
        return startPoint;
    }

    public void setStartPoint(Vector3d p) {
        startPoint = p;
    }

    public Vector3d getDirection() {
        return direction;
    }

    public void setDirection(Vector3d d) {
        direction = d;
    }
}
