package graphics.graph;

import java.awt.*;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class MouseEventHandler
        implements MouseListener, MouseMotionListener
        /**
         *	This used to be the class called MousePanel.
         *	The responsibility of this class is to listen for MouseEvents
         *	including clicks, drags, etc. and handle them appropriately.
         *	A Component will be passed in as part of the Constructor.
         *	It is on that component that the gui.mouse.m2.mouse events will be handled.
         *	When the appropriate response has been calculated, a message
         *	is sent to repaint the component and the gui.mouse.m2.mouse event is consumed.
         */ {
    private PickBean pb = PickBean.getPickBean();
    private PickFixedBean pfb = PickFixedBean.getPickFixedBean();
    private Nodes nodes = GraphFactory.getNodes();
    private Component component;

    public MouseEventHandler(Component c) {
        component = c;
    }

    //1.1 event handling
    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        component.addMouseMotionListener(this);
        double bestdist = Double.MAX_VALUE;
        int x = e.getX();
        int y = e.getY();
        for (int i = 0; i < nodes.getNumberOfNodes(); i++) {
            Node n = nodes.getNode(i);
            double dist = (n.getX() - x) * (n.getX() - x)
                    + (n.getY() - y) * (n.getY() - y);
            if (dist < bestdist) {
                pb.setPick(n);
                bestdist = dist;
            }
        }
        Node pickedNode = pb.getPick();
        pfb.setPickFixed(pickedNode.isFixed());
        pickedNode.setFixed(true);
        pickedNode.setX(x);
        pickedNode.setY(y);
        component.repaint();
        e.consume();
    }

    public void mouseReleased(MouseEvent e) {
        component.removeMouseMotionListener(this);
        Node n = pb.getPick();
        if (n != null) {
            n.setX(e.getX());
            n.setY(e.getY());
            if (e.isShiftDown())
                n.setFixed(true);
            else
                n.setFixed(pfb.getPickFixed());
            if (e.isAltDown())
                n.setFixed(false);

            pb.setPick(null);
        }
        component.repaint();
        e.consume();
    }

    public void mouseDragged(MouseEvent e) {
        if (pb.getPick() == null) return;
        pb.getPick().setX(e.getX());
        pb.getPick().setY(e.getY());
        component.repaint();
        e.consume();
    }
}