package graphics.graph;

public class GraphFactory
        /**
         *	The responsibility of the GraphFactory
         *	is to return instances of objects that
         *	are current for the test instance.
         *	In other words, it provides a handle to
         *	the instance of objects needed for the
         *	current test without having to make them
         *	singleton design pattern objects.
         */ {
    private static Nodes nodes = new Nodes();
    private static ColorPanel cp = new ColorPanel();
    private static EdgesManager em = new EdgesManager();
    private static NodeDrawer nd = new NodeDrawer();
    private static ImageBuffer iu = new ImageBuffer();

    public static EdgesManager getEdgesManager() {
        return em;
    }

    public static ColorPanel getColorPanel() {
        return cp;
    }

    public static Nodes getNodes() {
        return nodes;
    }

    public static NodeDrawer getNodeDrawer() {
        return nd;
    }

    public static ImageBuffer getImageUtil() {
        return iu;
    }
}