//Paul S. Underwood
//SW409
//February 9, 2005

package futils.filters;

import java.io.*;
import java.util.Date;
import java.util.prefs.Preferences;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Jan 8, 2005
 * <p/>
 * Time: 8:47:05 AM
 */

//Define bit masks for file filtering
class BitMasks{
    //Constructor private to prevent instantiation
    private BitMasks(){
    }

    //One bit per input selection control; may be combined into mask
    public static final int NO_BITS = 0x00;
    public static final int FILE_BIT = 0x01;
    public static final int DIRECTORY_BIT = 0x02;
    public static final int DATED_BIT = 0x04;
}

public class DateFilterBean implements Serializable {
    private boolean isDirectory = true;
    private boolean isFile = true;
    private boolean dated = true;

    private String suffix = null;

    private Date date = new Date();
    private static final String key = "DateFilterBean";

    private DateFilterBean() {

    }
    public void setSuffix(String suffix){
        System.out.println("setting suffix="+suffix);
        this.suffix = suffix;
    }
    public String getSuffix(){
        return suffix;
    }
    public String toString() {
        return "isDirectory="+isDirectory+
                "\nisFile="+isFile+
                "\ndate="+date;
    }

    //Create an aggregated bit mask for file filtering
    private int getSelector(){
        int retVal = BitMasks.NO_BITS;
        if(isFile()) retVal |= BitMasks.FILE_BIT;
        if(isDirectory()) retVal |= BitMasks.DIRECTORY_BIT;
        if(isDated()) retVal |= BitMasks.DATED_BIT;
        return retVal;
    }

    //Create a file filter, providing the selector determined
    //by check box settings
    public FileFilter getFileFilter() {
        FileFilter ff = new DateFilter(this, getSelector());
        return ff;
    }

    public boolean isDirectory() {
        return isDirectory;
    }

    public void setDirectory(boolean directory) {
        isDirectory = directory;
    }

    public boolean isFile() {
        return isFile;
    }

    public void setFile(boolean file) {
        isFile = file;
    }

    public Date getDate() {
        return date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    /**
     * saves the properties to the Preferences of the userRoot
     */
    public void save() {
        try {
            Preferences p = Preferences.userRoot();
            ByteArrayOutputStream baos = new
                    ByteArrayOutputStream();
            ObjectOutputStream oos = new
                    ObjectOutputStream(baos);
            oos.writeObject(this);
            baos.close();
            p.putByteArray(key, baos.toByteArray());
        } catch (IOException e) {
            //e.printStackTrace();
        }
    }

    /**
     * restores the properties from the preference in the user root.
     */
    public static DateFilterBean restore() {
        try {
            Preferences p = Preferences.userRoot();
            byte b [] = p.getByteArray(key, null);
            if (b == null)
                return new DateFilterBean();
            ByteArrayInputStream bais = new
                    ByteArrayInputStream(b);
            ObjectInputStream ois = new
                    ObjectInputStream(bais);
            Object o = ois.readObject();
            bais.close();
            return (DateFilterBean) o;
        } catch (IOException e) {
        } catch (ClassNotFoundException e) {
        }
        return new DateFilterBean();
    }

    public boolean isDated() {
        return dated;
    }

    public void setDated(boolean dated) {
        this.dated = dated;
    }
}
