package futils;

// futils.ReaderUtil

import gui.In;
import utils.BooleanException;
import utils.StringUtils;
import xml.adbk.SimpleAddress;
import xml.adbk.SimpleAddressBook;

import javax.swing.*;
import java.awt.*;
import java.io.*;
import java.util.StringTokenizer;
import java.util.Vector;

public class ReaderUtil {
    private static BufferedReader br =
            new BufferedReader(new InputStreamReader(System.in));


    public static void setReader(BufferedReader _br) {
        br = _br;
    }

    public static BufferedReader getReader() {
        return br;
    }

    public static String getString(String prompt) {
        if (prompt != null)
            System.out.print(prompt);
        try {
            return br.readLine();
        } catch (IOException e) {
        }
        return null;
    }

    public static byte[] getBytes(int i) throws IOException {
        byte newLine[] = "\n".getBytes();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(Integer.toString(i).getBytes());
        baos.write(newLine);
        return baos.toByteArray();
    }

    public static int[] getInt(byte b[]) {
        int ia[] = new int[b.length];
        for (int i = 0; i < b.length; i++)
            ia[i] = b[i];
        return ia;
    }

    public static void testGetInts() {
        int ia[] = getInts(0.111f);
        print(ia);
    }

    public static int[] getInts(float f) {
        byte newLine[] = "\n".getBytes();
        byte fb[] = Float.toString(f).getBytes();
        int ia[] = new int[newLine.length + fb.length];
        for (int i = 0; i < fb.length; i++)
            ia[i] = fb[i];
        ia[fb.length] = newLine[0];
        return ia;
    }

    public static byte[] getBytes(String o[]) throws IOException {
        byte newLine[] = "\n".getBytes();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (int i = 0; i < o.length; i++) {
            baos.write(o[i].toString().getBytes());
            baos.write(newLine);
        }
        return baos.toByteArray();
    }

    public static void print(Object o[]) {
        for (int i = 0; i < o.length; i++)
            System.out.println(o[i]);
    }

    public static void print(int o[]) {
        for (int i = 0; i < o.length; i++)
            System.out.println(o[i]);
    }

    public static int sum(int o[]) {
        int s = 0;
        for (int i = 0; i < o.length; i++)
            s = s + o[i];
        return s;
    }

    public static int[] string2Int(String s[]) {
        int ia[] = new int[s.length];
        for (int i = 0; i < s.length; i++)
            ia[i] = Integer.parseInt(s[i]);
        return ia;
    }

    public static String[]
            getTokens(String s) {
        StringTokenizer
                st = new StringTokenizer(s,
                        ", \t\n\r\f\\");
        int n = st.countTokens();
        System.out.println("n=" + n);
        String t[] = new String[n];
        for (int i = 0; i < n; i++)
            t[i] = st.nextToken();
        return t;
    }

    public static void testGetFile() {
        try {
            String sa[] = getFile(Futil.getReadFile("select a text file"));
            print(sa);
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static String[] getFile(File f) throws FileNotFoundException {
        Vector v = new Vector();
        if (f==null) return null;
        BufferedReader br = new BufferedReader(new FileReader(f));
        String s = null;
        try {
            while ((s = br.readLine()) != null)
                v.addElement(s);
        } catch (IOException e) {
            e.printStackTrace();
        }
        close(br);
        String sa[] = new String[v.size()];
        v.copyInto(sa);
        return sa;
    }

    /**
     * Obtain a list of records using
     * a given record delimiter. For example, input
     * a file and a delimiter (^m) and return an array
     * of records.
     * <br>
     * String s[] = getRecords(f, '\r');
     * <br>
     * In java, C and C++, '\r' = carrage return,
     * '\f' = form feed (or line feed)
     * ^m is a carrage...
     *
     * @return unparsed array of records as <code>String</code>
     */
    public static SimpleAddressBook getAddressBook() {
        Futil.setSwing(false);
        File f = Futil.getReadFile("select a file to read");
        try {
            return getAddressBook(f, ";");
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * Do a getRecords with
     *
     * @param f as the input file
     * @param c as the delimiting character
     * @return records in the order in which they appear in the file
     */
    public static SimpleAddressBook getAddressBook(File f, String c) throws IOException {
        StringBuffer sb = new StringBuffer();
        FileReader fr = new FileReader(f);
        BufferedReader br = new BufferedReader(fr);
        String s = br.readLine();
        while (s != null) {
            sb.append(s);
            s = br.readLine();
        }
        fr.close();
        StringTokenizer st = new StringTokenizer(sb.toString(), c);
        SimpleAddress sa = getAddress(st);
        SimpleAddressBook sab = new SimpleAddressBook();
        while (sa != null) {
            sab.add(sa);
            sa = getAddress(st);
        }
        return sab;
    }

    private static SimpleAddress getAddress(StringTokenizer st) {
        int n = st.countTokens();
        if (n < 6) return null;
        SimpleAddress sa = new SimpleAddress();
        sa.setName(st.nextToken());
        sa.setAddress(st.nextToken());
        sa.setInfo(st.nextToken());
        sa.setHomePhone(st.nextToken());
        sa.setBusinessPhone(st.nextToken());
        sa.setFaxPhone(st.nextToken());
        return sa;
    }

    public static void listFile() {
        Futil.setSwing(false);
        FileReader fr =
                getFileReader("select a text file");
        System.out.println("file is:" + fr.toString());
        BufferedReader br = new BufferedReader(fr);
        String s = null;
        try {
            while ((s = br.readLine()) != null) {
                System.out.println(s);
                System.out.println("-----");
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
        close(br);
    }

    public static void readQuestion(String s) {
        System.out.println("question=" + s);
    }

    public static void testGetTokenizer() {
        String s = getString("please enter a string of data:");
        System.out.println("s=" + s);
        String a[] = getTokens(s);
        int ia[] = string2Int(a);
        print(ia);
        System.out.println("sum=" + sum(ia));
    }

    /**
     * isReadableFile() - validates the file is
     * exists and readable
     *
     * @param f The file to be examined.
     * @return boolean - file is readable
     *         true/false
     */
    public static boolean isReadableFile(File f) {
        try {
            if (!f.exists())
                throw (new FileNotFoundException("No Such File :" + f));
            if (!f.canRead())
                throw (new IOException("File Not Readable: " +
                        f));
            return true;
        } catch (FileNotFoundException e) {
            System.out.println(e.getMessage() + "\n");
            return false;
        } catch (IOException e) {
            System.out.println(e.getMessage() + "\n");
            return false;
        }
    }

    /**
     * "@param prompt
     */
    public static BufferedReader getBufferedReader(String prompt) {
        return getBufferedReader(Futil.getReadFile(prompt));
    }

    /**
     * "@param f
     */
    public static BufferedReader
            getBufferedReader(File f) {
        if (f == null) return null;
        try {
            return new BufferedReader(new FileReader(f));
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * @param br
     */
    public static String readLine(BufferedReader br) {
        try {
            return br.readLine();
        } catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    /**
     * "@param br
     */
    public static void close(BufferedReader br) {
        try {
            br.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * Prompt the user for a file select and
     * return the File instance.
     *
     * @param prompt String displayed in a dialog
     * @return File selected by a user
     */
    private static File getReadFileAWT(String prompt) {
        FileDialog fd = new FileDialog(new Frame(), prompt);
        fd.setVisible(true);
        return new File(fd.getDirectory() + fd.getFile());
    }

    public static void testGetReadFile() {
        System.out.println("file=" +
                Futil.getReadFile("select a file"));
    }

    private static File getReadFileSwing(String prompt) {
        JFileChooser jfc = new JFileChooser();
        jfc.showOpenDialog(new JFrame());
        return jfc.getSelectedFile();
    }

    public static FileReader getFileReader(String prompt) {
        return getFileReader(Futil.getReadFile(prompt));
    }

    public static FileReader getFileReader(File file) {
        FileReader fr = null;
        try {
            fr = new FileReader(file);
        } catch (IOException e) {
            System.out.println("futil:Could not open file");
        }
        return fr;
    }

    public static void close(FileReader fr) {
        try {
            fr.close();
        } // end try
        catch (IOException exe) {
            System.out.println("could not close FileReader");
        }
    }

    /**
     * @param file
     * @param data
     * @throws IOException
     */
    public static void readDataFile(File file,
                                    double data[])
            throws IOException {
        System.out.println("processing:\t" + file);
        FileReader fr = getFileReader(file);
        StreamTokenizer tokens = new StreamTokenizer(fr);
        int next = 0;
        int num = 0;
        while ((next = tokens.nextToken()) !=
                StreamTokenizer.TT_EOF) {
            switch (next) {
                case StreamTokenizer.TT_WORD:
                    break;
                case StreamTokenizer.TT_NUMBER:
                    data[num] = tokens.nval;
                    System.out.println(num +
                            ": " +
                            data[num]);
                    num = num + 1;
                    break;
                case StreamTokenizer.TT_EOL:
                    break;
            }
        }
        close(fr);
    }

    /**
     * Prompts the user for a file and counts the
     * tokens.
     *
     * @return returns the number of tokens in a
     *         file
     */
    public static int countTokens(BufferedReader br) {
        String line = null;
        int k = 0;
        try {
            while ((line =
                    br.readLine()) != null) {
                k =
                        k +
                        StringUtils.addTokens(line);
            }
        } catch (IOException e) {
        }
        return k;
    }

    public static void listFilteredHrefFile(File file) {
        System.out.println("processing:\t" + file);
        try {
            FileReader fr = getFileReader(file);
            StreamTokenizer tokens = new
                    StreamTokenizer(fr);
            int next = 0;
            tokens.resetSyntax();
            tokens.wordChars(0, 255);
            tokens.quoteChar('"');
            while ((next = tokens.nextToken()) !=
                    StreamTokenizer.TT_EOF) {
                switch (next) {
                    case '"':
                        System.out.print('"');
                        StringTokenizer st =
                                new StringTokenizer(tokens.sval,
                                        " ");
                        while (st.hasMoreTokens()) {
                            System.out.print(st.nextToken());
                            if (st.countTokens() >
                                    1) {
                                System.out.print("%20");
                            }
                        }
                        System.out.print('"');
                        break;
                    case StreamTokenizer.TT_WORD:
                        System.out.print(tokens.sval +
                                " ");
                        break;
                    case StreamTokenizer.TT_NUMBER:
                        System.out.print(tokens.nval +
                                " ");
                        break;
                    case StreamTokenizer.TT_EOL:
                        System.out.println();
                        break;
                }
            }
            System.out.println();
            fr.close();
        } catch (Exception exe) {
            System.out.println("listFilteredHrefFile:er!");
        }
    }

    public static boolean parseBoolean(String s)
            throws BooleanException {
        if (s.equals("true")) return true;
        if (s.equals("false")) return false;
        throw new BooleanException();
    }

    public static boolean getBoolean(String prompt) {
        String s = getString(prompt);
        return parseBoolean(s);
    }

    public static int getInt(String prompt) {
        String s = getString(prompt);
        int i = 0;
        try {
            i = Integer.parseInt(s);
        } catch (NumberFormatException e) {
            System.out.println(s +
                    " is not a valid int, try again");
            return getInt(prompt);
        }
        return i;
    }

    public static double getDouble(String prompt) {
        String s = getString(prompt);
        double d = 0;
        try {
            d = Double.parseDouble(s);
        } catch (NumberFormatException e) {
            System.out.println(s +
                    " is not a valid double, try again");
            return getDouble(prompt);
        }
        return d;
    }

    /**
     * Returns the <b><code>file</code></b> instance as a string, reading
     * it in, one line at a time.
     *
     * @param f is used as input
     * @return file contents of the file in one big string;
     */
    public static String getFileAsOneBigString(File f) {
        if (f == null) return null;
        StringBuffer sb = new StringBuffer();
        try {
            String s[] = getFile(f);

            for (int i=0; i < s.length; i++)
                sb.append(s[i]+'\n');
        } catch (FileNotFoundException e) {
            In.message(e);

        }
      return sb.toString();
    }

    public static void main(String args[]) {
        System.out.println(ReaderUtil.getFileAsOneBigString(
                Futil.getReadFile("select a text file")));
    }
}
