package futils;

import futils.filters.DateFilterBean;
import futils.filters.DateFilterDialog;
import futils.filters.DirFilter;
import gui.In;

import javax.swing.*;
import java.awt.*;
import java.io.File;
import java.io.FileFilter;
import java.util.Collections;
import java.util.Vector;

/**
 * DirList, w/o recursion.
 */
public class DirList {
    private File startDir;
    private Vector history = new Vector();
    private int totalBytes = 0;
    private boolean verbose = false;
    private ProgressPanel progressPanel = new ProgressPanel();
    private FileFilter fileFilter = null;

    public File findFile(String fn) {
        File fa[] = getFilesNotDirectories();
        if (fa == null) In.message("ER:DirList.findFile has no files!");
        if (fa.length ==0) In.message("ER:DirList return 0 length in findFile");
        for (int i = 0; i < fa.length; i++)
            if (fa[i].getName().equalsIgnoreCase(fn))
                return fa[i];
        In.message("danger; could not find image:" + fn);
        return fa[0];
    }

    public class ProgressPanel extends JDialog {
        JLabel jl = new JLabel("file #");
        JLabel fl = new JLabel("0");
        int i = 0;

        ProgressPanel() {
            Container c = getContentPane();
            c.setLayout(new FlowLayout());
            c.add(jl);
            c.add(fl);
            setSize(200, 200);
        }

        public void incrementValue() {
            fl.setText("" + i++);
        }
    }

    public static void main(String args[]) {
        DateFilterDialog dfd = new DateFilterDialog();
        dfd.pack();
        dfd.show();
        final DateFilterBean dateFilterBean = dfd.getDateFilterBean();
        System.out.println(dateFilterBean);
        dateFilterBean.save();
        DirList dl = new DirList(Futil.getDir("select start dir"),
                dateFilterBean.getFileFilter());
        dl.sort();
        dl.printFiles(dl.getFilesNotDirectories());
        dl.printFiles(dl.getDirectoriesNotFiles());
        dl.printStats();
        //if (In.getBoolean("do you want to delete the files?")) {
        //    File fa[] = dl.getFilesNotDirectories();
        //    for (int i = 0; i < fa.length; i++)
        //        fa[i].delete();
       // }

    }

    public void sort() {
        Collections.sort(history);
    }

    public DirList(String suffix) {
        this(Futil.getDir("select a start point"),
                new WildFilter(suffix));
    }

    public DirList(File dir, String suffix) {
        this(dir, new WildFilter(suffix));
    }

    public DirList(File startDirectory, FileFilter fileFilter) {
        this.fileFilter = fileFilter;
        startDir = startDirectory;
        startAtThisDir(startDir);
    }
    public DirList(File startDirectory, FileFilter fileFilter,boolean progressBar) {

        this.fileFilter = fileFilter;
        startDir = startDirectory;
        if (progressBar)
            progressPanel.show();
        startAtThisDir(startDir);
        progressPanel.hide();
    }

    public void printStats() {
        System.out.println("Saw " +
                getTotalFiles() +
                " files with a total size of " +
                totalBytes +
                " bytes");
    }

    private void printFiles(File[] f) {
        System.out.println("-------");
        for (int i = 0; i < f.length; i++)
            System.out.println(f[i]);
    }

    public final void printVerbose(Object o) {
        if (verbose)
            System.out.println(o);
    }

    //-------------------------------------------------------
    // Recursive function that given an anchor directory
    // will walk directory gui.tree
    //
    //-------------------------------------------------------
    public void startAtThisDir(File f1) {
        printVerbose("Selected -> " + f1);
        printVerbose("Files in this Directory: ");
        addFilesInThisDirectory(f1);
        processAllDirectoriesInThisDirectory(f1);
    }

    private Vector vecDir = new Vector();

    private File nextDir() {
        return (File) vecDir.remove(vecDir.size() - 1);
    }

    private void addDirs(File dirList[]) {
        if (dirList == null) return;
        for (int i = 0; i < dirList.length; i++)
            vecDir.addElement(dirList[i]);
    }

    private void processAllDirectoriesInThisDirectory(File f1) {
        addDirs(f1.listFiles(new DirFilter()));
        while (vecDir.size() > 0) {
            File f = nextDir();
            printVerbose("Selected -> " + f);
            printVerbose("Files in this Directory: ");
            addFilesInThisDirectory(f);
            addDirs(f.listFiles(new DirFilter()));
        }
    }

    //-------------------------------------------------------
    // Loop through all the filenames in the current directory
    // and store them in history:
    //-------------------------------------------------------
    private void addFilesInThisDirectory(File f1) {
        progressPanel.incrementValue();
        File ls[] = f1.listFiles(fileFilter);
        if (ls == null) return;
        for (int i = 0; i < ls.length; i++)
            addFile(ls[i]);
    }

    private void addFile(File f2) {
        int bytes = Futil.available(f2);
        totalBytes += bytes;
        printVerbose(f2 +
                " has " +
                bytes + " bytes");
        history.addElement(f2);
    }

    public File getStartDir() {
        return startDir;
    }

    public File[] getDirectoriesNotFiles() {
        Vector v = new Vector();
        for (int i = 0; i < history.size(); i++) {
            File f = (File) history.elementAt(i);
            if (f.isDirectory())
                v.addElement(f);
        }
        File f[] = new File[v.size()];
        v.copyInto(f);
        return f;
    }

    public File[] getFilesNotDirectories() {
        Vector v = new Vector();
        for (int i = 0; i < history.size(); i++) {
            File f = (File) history.elementAt(i);
            if (f.isFile())
                v.addElement(f);
        }
        File f[] = new File[v.size()];
        v.copyInto(f);
        return f;
    }

    public File[] getFiles() {
        File f[] = new File[history.size()];
        history.copyInto(f);
        return f;
    }
    //todo fix this
    public File[] getFiles(String suffix) {
        Vector v = new Vector();
        for (int i=0; i < history.size(); i++) {
            File f = (File) history.elementAt(i);
            if (!f.canRead()) continue;
            if (f.isDirectory()) continue;
            if (f.getName().endsWith(suffix)) v.addElement(f);
        }
        File f[] = new File[v.size()];
        v.copyInto(f);
        return f;
    }
    public int getTotalBytes() {
        return totalBytes;
    }

    public int getTotalFiles() {
        return history.size();
    }
}



