package futils;

import gui.ClosableJFrame;
import gui.run.DelimiterBean;
import gui.run.RunDelimiterPanel;
import utils.StringUtils;

import java.awt.*;
import java.util.StringTokenizer;
import java.util.Vector;

/**
 * Created by IntelliJ IDEA.
 * User: dlyon
 * Date: Apr 20, 2005
 * Time: 7:34:16 PM
 * Copyright DocJava, 2005
 */
public class DelimiterProcessor implements LineProcessor {
    private DelimiterBean db = null;
    private Vector v = new Vector();

    public DelimiterProcessor(DelimiterBean db) {
        this.db = db;
    }

    public String[] getFields() {
        String s[] = new String[v.size()];
        v.copyInto(s);
        return s;
    }

    public void process(String s) {
        s = StringUtils.replaceAll(s, db.getLineDelimiter(), "\n");
        StringTokenizer st = new StringTokenizer(s, db.getFieldDelimiter());
        while (st.hasMoreTokens())
            v.addElement(st.nextToken());

    }

    public void process() {

        String s =
                ReaderUtil.getFileAsOneBigString(Futil.getReadFile("select text file"));
        StringTokenizer st = new StringTokenizer(s, db.getRecordDelimiter());
        while (st.hasMoreTokens()) {
            process(st.nextToken());
            print();
        }

    }

    public void print() {
        String s[] = getFields();
        for (int i = 0; i < s.length; i++) {
            System.out.println(s[i]);
        }
    }

    public static void main(String[] args) {
        ClosableJFrame cf = new ClosableJFrame();
        Container c = cf.getContentPane();
        c.add(new RunDelimiterPanel() {
            public void run() {
                DelimiterProcessor dp = new DelimiterProcessor(getDelimiterBean());
                dp.process();
            }
        });
        cf.pack();
        cf.setVisible(true);

    }

}
