/*
 * Timer.java
 *
 * Created on October 30, 2002
 */

package collections.stringswitch;

import java.io.PrintStream;

/**
 * @author  Thomas Rowland
 */
public class Timer {

    private long base_time;
    private long elapsed_time;
    private static final long UNIT = 1000;

    /** Creates a new instance of Timer */
    public Timer() {
        clear();
    }

    public void mark() {
        base_time = System.currentTimeMillis();
    }

    public void clear() {
        elapsed_time = 0;
    }

    public void record() {
        elapsed_time += (System.currentTimeMillis() - base_time);
    }

    public float elapsed() {
        return ((float) elapsed_time) / UNIT;
    }

    public void report(PrintStream ps) {
        float elapsed_secs = elapsed();
        ps.println("Time " + elapsed_secs + " sec");
    }

    public void report() {
        report(System.out);
    }

}
