package classUtils.resolver.interfaces;

/**
 * @author Douglas Tillman, VTE Consulting, 12/2002
 * @version 2.0
 * Simple interface to allow for change of audit implementation
 * if necessary/desired. 
 */

import java.io.*;

/**
 * Interface for objects that want to observe directory traversals.
 */
public interface WalkObserver
{
    /**
     * The WalkObserver entrypoint.  Shows each file in a tree traversal.
     * @param f File encountered
     * @param indentLevel Level of recursion
     */
    public void at(File f, int indentLevel);
}
