package classUtils.resolver.interfaces;

import java.util.Map;
import java.util.jar.*;
import java.io.File;

/**
 * @author Douglas Tillman, VTE Consulting, 12/2002
 * @version 2.0
 * Simple interface to allow for change of audit implementation
 * if necessary/desired. 
 */
public interface Auditor {
	/**
	 * Adds a .jar file to the audit. Note the parameter isn't java.util.JarFile.
	 * @param com.vtecinc.model.JarFile
	 */
	public void addJarFileToAudit(JarFile j);
	
	/**
	 * Standard getter
	 * @return Map of all .jar files audited.
	 */
	public Map getMasterJarList();
	
	/**
	 * Standard getter
	 * @return Map of all duplicate .jar files audited.
	 */
	public Map getDuplicateJarList();
	
	/**
	 * Standard getter
	 * @return Map of all class files audited.
	 */
	public Map getMasterClassList();
	
	/**
	 * Standard getter
	 * @return Map of all duplicate class files audited.
	 */
	public Map getDuplicateClassList();
	

}
