package classUtils.putils;

// classUtils.putils.ClassPathDialog

import classUtils.resolver.gui.JarPanel;
import futils.Futil;
import futils.Ls;
import gui.In;
import gui.ClosableJFrame;
import gui.run.RunMenu;
import gui.run.RunMenuItem;

import javax.swing.*;
import java.awt.*;
import java.io.File;
import java.io.IOException;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Jan 3, 2005
 * <p/>
 * Time: 8:56:25 AM
 */
public class ClassPathDialog extends JDialog {
    private ClassPathBean cpb = null;
    private DefaultListModel model = new DefaultListModel();
    private JList jl = null;


    JScrollPane jsp = null;

    public ClassPathDialog(ClassPathBean cpb) {
        this.cpb = cpb;
        refreshList();
        jl = new JList(model);
        jl.setBorder(BorderFactory.createEtchedBorder());
        JPanel jp = new JPanel();
        jp.setLayout(new GridLayout(1,0));
        jp.add(jl);
        setMenuBar();
        setModal(true);
        jsp = new JScrollPane(jp);

        Container c = getContentPane();
        c.add(jsp);
    }


    public ClassPathBean getClassPathBean() {
        return cpb;
    }

    private void refreshList() {
        String[] items = cpb.getClassPaths();
        for (int i = 0; i < items.length; i++)
            model.addElement(items[i]);
    }


    public static void main(String[] args) {
        ClassPathDialog cpd = new ClassPathDialog(ClassPathBean.restore());
        cpd.pack();
        cpd.setVisible(true);
    }

    public void print(Object o[]) {
        for (int i = 0; i < o.length; i++)
            System.out.println(o[i]);
    }

    public void restoreFromProperties() {
        String classPaths[] = ClassPathUtils.getClassPaths();
        model.removeAllElements();
        for (int i = 0; i < classPaths.length; i++)
            model.addElement(classPaths[i]);
        repaint();

    }

    public void setMenuBar() {
        JMenuBar jm = new JMenuBar();
        RunMenu runMenu = new RunMenu("[Run");
        runMenu.add(new RunMenuItem("[clear list^c") {
            public void run() {
                clearList();
            }
        });
        runMenu.add(new RunMenuItem("[refresh list^r") {
            public void run() {
                refreshList();
            }
        });
        runMenu.add(new RunMenuItem("show jar explorer") {
            public void run() {
                jarExplorer();
            }
        });
        runMenu.add(new RunMenuItem("add dir recursively") {
            public void run() {
                addDirRecursively();
            }
        });
        runMenu.add(new RunMenuItem("restore from [props^p") {
            public void run() {
                restoreFromProperties();
            }
        });
        runMenu.add(new RunMenuItem("[add files to classpaths^a") {
            public void run() {
                addFiles();
            }
        });
        runMenu.add(new RunMenuItem("[add dirs to classpaths^a") {
            public void run() {
                addDirs();
            }
        });
        runMenu.add(new RunMenuItem("Remove selected values^R") {
            public void run() {
                deleteSelection();
            }
        });

        runMenu.add(new RunMenuItem("[save list^s") {
            public void run() {
                saveList();
            }
        });
        runMenu.add(new RunMenuItem("[done^d") {
            public void run() {
                ClassPathDialog.this.setVisible(false);
            }
        });
        runMenu.add(new RunMenuItem("e[xit program^e") {
            public void run() {
                System.exit(0);
            }
        });
        jm.add(runMenu);
        setJMenuBar(jm);
    }

    private void jarExplorer() {
        try {
            setVisible(false);
            ClosableJFrame cf = new ClosableJFrame();
            JarPanel jarPanel = new JarPanel(cpb.getJarsAndZips());
            JScrollPane jsp = new JScrollPane(jarPanel);
            final Container c = cf.getContentPane();
            c.add(jsp);
            cf.setSize(400,400);
            cf.setVisible(true);
        } catch (IOException e) {
            In.message(e);
        }
    }

    private void addDirRecursively() {
        addDirRecursively(jl.getSelectedIndices()[0]);
    }

    private void addDirRecursively(int index) {
        Object o = model.elementAt(index);
        File f = new File(o.toString());
        if (f.isDirectory())
            expandDir(f);
        else
            In.message(" f is not a dir:" + f);
    }

    private void expandDir(File f) {
        File fa[] = Ls.getDirs(f);
        for (int i = 0; i < fa.length; i++) {
            model.addElement(fa[i].getAbsolutePath());
            expandDir(fa[i]);
        }
        pack();
        repaint();
    }

    private void addDirs() {
        File f[] = Futil.getReadDirs();
        if (f == null) return;
        for (int i = 0; i < f.length; i++)
            model.addElement(f[i].getAbsolutePath());
        pack();
        repaint();
    }

    private void addFiles() {
        File f[] = Futil.getReadFiles("add files to class path");
        if (f == null) return;
        for (int i = 0; i < f.length; i++)
            model.addElement(f[i].getAbsolutePath());
        pack();
        repaint();
    }

    private void saveList() {
        Object o[] = model.toArray();
        String cp[] = new String[model.size()];
        for (int i = 0; i < o.length; i++)
            cp[i] = (String) o[i];
        cpb.setClassPaths(cp);
        cpb.save();
    }

    private void clearList() {
        model.removeAllElements();
    }

    private void deleteSelection() {
        int sel[] = jl.getSelectedIndices();
        model.removeRange(sel[0], sel[sel.length - 1]);
        repaint();
    }
}
