package classUtils.putils;
// classUtils.putils.ClassPathDialog

import futils.Futil;
import gui.run.RunMenu;
import gui.run.RunMenuItem;

import javax.swing.*;
import java.io.File;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Jan 3, 2005
 * <p/>
 * Time: 8:56:25 AM
 */
public class ClassListDialog extends JDialog {
    ClassListBean clb = null;
    DefaultListModel model = new DefaultListModel();
    JList jl = null;

    JPanel jp = new JPanel();


    public ClassListDialog(ClassListBean clb){

        this.clb = clb;
        refreshList();
        jl = new JList(model);
        setMenuBar();
        setModal(true);
        JScrollPane jsp = new JScrollPane(jl);
        setContentPane(jsp);
    }


    public ClassListBean getClassListBean(){
        return clb;
    }

    private void refreshList() {
        Class[] items = clb.getClasses();
        for (int i = 0; i < items.length; i++){
            model.addElement(items[i]);
            System.out.println("adding:"+items[i]);
        }
    }


    public static void main(String[] args) {
        ClassListDialog cpd = new ClassListDialog(
                ClassListBean.restore());
        cpd.pack();
        cpd.setVisible(true);
    }

    public void print(Object o[]){
        for (int i=0; i < o.length; i++)
            System.out.println(o[i]);
    }
    public void scanForClasses(){
        clb.scan();
        Class classes[] = clb.getClasses();
        model.removeAllElements();
        for (int i=0; i < classes.length;i++)
            model.addElement(classes[i]);
        repaint();

    }
    public void setMenuBar() {
        JMenuBar jm = new JMenuBar();
        RunMenu runMenu = new RunMenu("[Run");
        runMenu.add(new RunMenuItem("[clear list^c") {
            public void run() {
               clearList();
            }
        });
        runMenu.add(new RunMenuItem("[refresh list^r") {
            public void run() {

                refreshList();
            }
        });
        runMenu.add(new RunMenuItem("scan for classes") {
            public void run() {
                scanForClasses();
            }
        });

        runMenu.add(new RunMenuItem("[add files to classpaths^a") {
            public void run() {
                addFiles();
            }
        });
        runMenu.add(new RunMenuItem("[add dirs to classpaths^a") {
            public void run() {
                addDirs();
            }
        });
        runMenu.add(new RunMenuItem("Remove selected values^R") {
            public void run() {
                deleteSelection();
            }
        });

        runMenu.add(new RunMenuItem("[save list^s") {
            public void run() {
                saveList();
            }
        });
        runMenu.add(new RunMenuItem("[done^d") {
            public void run() {
                ClassListDialog.this.setVisible(false);
            }
        });
        runMenu.add(new RunMenuItem("e[xit program^e") {
            public void run() {
                System.exit(0);
            }
        });
        jm.add(runMenu);
        setJMenuBar(jm);
    }



    private void addDirs() {
        File f[] = Futil.getReadDirs();
        if (f == null) return;
        for (int i = 0; i < f.length; i++)
            model.addElement(f[i].getAbsolutePath());
        pack();
        repaint();
    }

    private void addFiles() {
        File f[] = Futil.getReadFiles("add files to class list");
        if (f== null) return;
        for (int i=0; i < f.length; i++)
            model.addElement(f[i].getAbsolutePath());
        pack();
        repaint();
    }

    private void saveList() {
        Object o[] = model.toArray();
        Class cp[]= new Class[model.size()];
        for (int i=0; i < o.length;i++)
            cp[i] = (Class)o[i];
        clb.setClasses(cp);
        clb.save();
    }

    private void clearList() {
        model.removeAllElements();
    }

    private void deleteSelection() {
        int sel[]=jl.getSelectedIndices();
        model.removeRange(sel[0], sel[sel.length - 1]);
        repaint();
    }
}
