package classUtils.pathUtils;

import classUtils.putils.ClassPathUtils;
import futils.DirList;
import futils.Futil;
import gui.JInfoFrame;
import gui.run.RunButton;

import javax.swing.*;
import java.awt.*;
import java.io.File;

public class PathTabbedPane extends JTabbedPane {
    JInfoFrame jif = new JInfoFrame();


    public PathTabbedPane(){
        ClassPathPanel classPathPanel = new ClassPathPanel();

        add(classPathPanel, "Class & Library View");
        add(getButtonControlPanel(),
                "Path controller");
        add(jif.getContentPane(),"Messages");
    }


    public void displayDialog() {
        JDialog jd = new JDialog();
        jd.setTitle("Class And Library Path Browser");
        jd.setModal(true);
        jd.getContentPane().add(this);
        jd.setSize(600, 400);
        jd.setVisible(true);
    }

    private void attachDirectory() {
        ClassPathUtils.addClassPath(Futil.getDir(
                "select a classes folder")
                .toString());

    }

    private void recursiveAttachDirectory() {
        File readFileDir = Futil.getDir("select a jars folder");
        DirList dl = new DirList(readFileDir, ".jar");
        File f[] = dl.getFilesNotDirectories();
        for (int i = 0; i < f.length; i++)
            ClassPathUtils.addClassPath(f[i].getAbsolutePath());
    }

    private void rebuildTree() {

            setVisible(false);
            initAndShowPathFrame();

    }

    private JPanel getButtonControlPanel() {
        JPanel jp = new JPanel();
        jp.setLayout(new FlowLayout());
        jp.add(new RunButton("attach directory...") {
            public void run() {
                attachDirectory();
            }
        });
        jp.add(new RunButton("recursive attach directory...") {
            public void run() {
                recursiveAttachDirectory();
            }
        });
        jp.add(new RunButton("print class path") {
            public void run() {
                printClassPath();
            }
        });
        jp.add(new RunButton("save class path") {
            public void run() {
                ClassPathUtils.saveClassPath();
            }
        });
        jp.add(new RunButton("restore class path") {
            public void run() {
                ClassPathUtils.restoreClassPath();
            }
        });
        jp.add(new RunButton("rebuild Tree") {
            public void run() {
                rebuildTree();
            }
        });
        return jp;
    }

    private void printClassPath() {
        String s[] = ClassPathUtils.getClassPaths();
        for (int i = 0; i < s.length; i++)
            jif.println(s[i]);
        jif.println("--------------------");
    }




    public static void main(String argv[]) {
        initAndShowPathFrame();
    }

    private static void initAndShowPathFrame() {
        PathTabbedPane pf = new PathTabbedPane();
        pf.displayDialog();
    }

    public static void fixClassPath() {
        main(null);
    }


}

