package classUtils.pathUtils;

import java.io.File;


public class FilePathNode extends ClassPathNode {
    File _file;
    boolean _topLevel;

    public FilePathNode(String title, File file, boolean topLevel) {
        super(title);
        _file = file;
        _topLevel = topLevel;

        if (!file.exists())
            setTitle(getTitle() + " (missing)");
    }

    public FilePathNode(File file) {
        this(file.getName(), file, false);
    }
}

