package classUtils.pack.util;

import java.lang.reflect.Array;

/**
 * An helper class to automatically wrap primitive types
 * into their corresponding object types.
 * 
 * @author Cristiano Sadun
 */
public class TypeWrapper {

	public static Object wrap(byte v) {
		return new Byte(v);
	}
	public static Object wrap(short v) {
		return new Short(v);
	}
	public static Object wrap(int v) {
		return new Integer(v);
	}
	public static Object wrap(long v) {
		return new Long(v);
	}
	public static Object wrap(float v) {
		return new Float(v);
	}
	public static Object wrap(double v) {
		return new Double(v);
	}
	public static Object wrap(char v) {
		return new Character(v);
	}
	public static Object wrap(boolean v) {
		return new Boolean(v);
	}

	public static Object wrap(Object obj) {

		if (!obj.getClass().isArray())
			throw new IllegalArgumentException("wrap(Object) can be invoked only on arrays of primitive types");

		Object[] array = (Object[]) obj;
		Class componentType = obj.getClass().getComponentType();
		Class baseComponentType = componentType;

		int dim = 1;

		while (baseComponentType.isArray()) {
			baseComponentType = baseComponentType.getComponentType();
			dim++;
		}

		if (!baseComponentType.isPrimitive())
			throw new IllegalArgumentException("wrap(Object) can be invoked only on arrays of primitive types");

		return wrap0(array, componentType, baseComponentType, dim);
	}

	private static Object wrap0(
		Object[] array,
		Class componentType,
		Class baseComponentType,
		int dim) {
		Object[] result = null;
		for (int i = 0; i < array.length; i++) {
			if (componentType.isArray()) {
				// Component type is an array. If the value of the ith element is
				// not null, go creating the subarray and assign it
				if (array[i] == null) {
					result[i] = null;
					continue;
				} else {
					Object[] elementArray = (Object[]) array[i];
					result[i] =
						wrap0(
							elementArray,
							componentType.getComponentType(),
							baseComponentType,
							dim - 1);
				}
			} else {
				// Component type is not an array. Since we're dealing with primitive
				// types, array elements are never null.

				// Let's create a corresponding array of wrappers		
				result =
					(Object[]) Array.newInstance(
						TypeWrapper.getWrapperClass(baseComponentType),
						1);
				// Now, let's fill the values with wrapper objects
				for (int j = 0; j < result.length; j++) {

				}
			}
		}
		return result;
	}

	/*
	private static Object [] wrap0(Object obj, int level, Class [] baseType) { 
		if (!obj.getClass().isArray()) 
			throw new IllegalArgumentException("wrap(Object) can be invoked only on arrays of primitive types");
			
		Class componentType = obj.getClass().getComponentType();
		if (componentType.isArray()) {
			// For each element, we need to obtain the wrapped array
			Object [] result=null;
			for(int i=0;i<((Object[])obj).length;i++) {
				Object elem = ((Object[])obj)[i];
				Object [] wrapped = wrap0(elem, level+1, baseType);
				// In "basetype", we've recorded the primitive type,
				// so we create an appropriate wrapper type array 
				if (result==null) {
					try {
						result = Array.n.newInstance()
					} catch (Exception e) {
						throw new RuntimeException(e);
					}
					System.exit(0);
				}
			/*
			if (componentType==byte[].class) wrappedArray=wrap0((byte)
			else if (componentType==Short.TYPE) wrappedValue=wrap(((short[])obj)[i]);
			else if (componentType==Integer.TYPE) wrappedValue=wrap(((int[])obj)[i]);
			else if (componentType==Long.TYPE) wrappedValue=wrap(((long[])obj)[i]);
			else if (componentType==Float.TYPE) wrappedValue=wrap(((float[])obj)[i]);
			else if (componentType==Double.TYPE) wrappedValue=wrap(((double[])obj)[i]);
			else if (componentType==Character.TYPE) wrappedValue=wrap(((char[])obj)[i]);
			else if (componentType==Boolean.TYPE) wrappedValue=wrap(((boolean[])obj)[i]);
			*
			}
			return result;
		}
		
		if (!componentType.isPrimitive())
			throw new IllegalArgumentException("wrap(Object) can be invoked only on arrays of primitive types");
		
		// Create an array of the wrapper type, and assign it
		// with wraps of the original value
		int length = getArrayLength(obj);
		baseType[0]=componentType;
		Object [] wrapperArray = createWrapperArray(componentType, length);
		for(int i=0;i<length;i++) {
			Object wrappedValue=null;
			if (componentType==Byte.TYPE) wrappedValue=wrap(((byte[])obj)[i]);
			else if (componentType==Short.TYPE) wrappedValue=wrap(((short[])obj)[i]);
			else if (componentType==Integer.TYPE) wrappedValue=wrap(((int[])obj)[i]);
			else if (componentType==Long.TYPE) wrappedValue=wrap(((long[])obj)[i]);
			else if (componentType==Float.TYPE) wrappedValue=wrap(((float[])obj)[i]);
			else if (componentType==Double.TYPE) wrappedValue=wrap(((double[])obj)[i]);
			else if (componentType==Character.TYPE) wrappedValue=wrap(((char[])obj)[i]);
			else if (componentType==Boolean.TYPE) wrappedValue=wrap(((boolean[])obj)[i]);
			wrapperArray[i]=wrappedValue;
		}
		return wrapperArray;
	}
	*/

	private static int getArrayLength(Object array) {
		Class componentType = array.getClass().getComponentType();
		if (componentType == Byte.TYPE)
			return ((byte[]) array).length;
		if (componentType == Short.TYPE)
			return ((short[]) array).length;
		if (componentType == Integer.TYPE)
			return ((int[]) array).length;
		if (componentType == Long.TYPE)
			return ((long[]) array).length;
		if (componentType == Float.TYPE)
			return ((float[]) array).length;
		if (componentType == Double.TYPE)
			return ((double[]) array).length;
		if (componentType == Character.TYPE)
			return ((char[]) array).length;
		if (componentType == Boolean.TYPE)
			return ((boolean[]) array).length;
		throw new IllegalArgumentException("getArrayLength() called over an array of nonprimitive types");

	}

	private static Object[] createWrapperArray(
		Class componentType,
		int length) {
		if (componentType == Byte.TYPE)
			return new Byte[length];
		if (componentType == Short.TYPE)
			return new Short[length];
		if (componentType == Integer.TYPE)
			return new Integer[length];
		if (componentType == Long.TYPE)
			return new Long[length];
		if (componentType == Float.TYPE)
			return new Float[length];
		if (componentType == Double.TYPE)
			return new Double[length];
		if (componentType == Character.TYPE)
			return new Character[length];
		if (componentType == Boolean.TYPE)
			return new Boolean[length];
		throw new IllegalArgumentException("createWrapperArray() called over a nonprimitive type");

	}

	/**
	 * Return the class of the wrapper object for the given
	 * primitive type.
	 * 
	 * @param primitiveCls the Class of the primitive type
	 * @return Class the wrapper class
	 */
	public static Class getWrapperClass(Class primitiveCls) {
		if (primitiveCls == Byte.TYPE)
			return Byte.class;
		if (primitiveCls == Short.TYPE)
			return Short.class;
		if (primitiveCls == Integer.TYPE)
			return Integer.class;
		if (primitiveCls == Long.TYPE)
			return Long.class;
		if (primitiveCls == Float.TYPE)
			return Float.class;
		if (primitiveCls == Double.TYPE)
			return Double.class;
		if (primitiveCls == Character.TYPE)
			return Character.class;
		if (primitiveCls == Boolean.TYPE)
			return Boolean.class;
		throw new IllegalArgumentException("getWrapper() called over a nonprimitive type");
	}

	/**
	 * Return a wrapper object corresponding to passed value, interpreted
	 * according to the given primitive class.
	 * 
	 * @param primitiveCls the Class of the primitive type
	 * @param value the value to intepret
	 */
	public static Object wrapFromString(Class primitiveCls, String value) {
		try {
			if (primitiveCls == Byte.TYPE)
				return new Byte(value);
			if (primitiveCls == Short.TYPE)
				return new Short(value);
			if (primitiveCls == Integer.TYPE)
				return new Integer(value);
			if (primitiveCls == Long.TYPE)
				return new Long(value);
			if (primitiveCls == Float.TYPE)
				return new Float(value);
			if (primitiveCls == Double.TYPE)
				return new Double(value);
			if (primitiveCls == Character.TYPE) {
				if (value.length() != 1)
					throw new IllegalArgumentException("Invalid value for character type");
				return new Character(value.charAt(0));
			}
			if (primitiveCls == Boolean.TYPE)
				return new Boolean(value);
		} catch (NumberFormatException e) {
			throw new IllegalArgumentException(
				"'"
					+ value
					+ "' is not a correct representation for the type "
					+ MethodSignatureAnalyzer.getJavaTypeName(primitiveCls));
		}
		throw new IllegalArgumentException("getWrapper() called over a nonprimitive type");
	}

	/*public Object interpretPrimitiveString(String value, Class cls) {
		Class primitiveCls=getWrapperClass(cls);
		return primitiveCls.
	}*/

	public static void main(String args[]) {

		Integer[][] wrapped =
			(
				Integer[][]) TypeWrapper
					.wrap(new int[][] { new int[] { 2, 5 }, new int[] { 3, 6 }
		});
	}

}
