package classUtils.pack.util;

import classUtils.pack.Constants;
import classUtils.putils.ClassPathUtils;
import gui.JInfoFrame;
import org.apache.tools.ant.Task;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Jan 2, 2005
 * <p/>
 * Time: 9:21:46 AM
 */
class PackTask extends Task {
    private Pack pack;

    public PackTask(Pack pack) {
        this.pack = pack;
    }


    /**
     * Execute the task.
     *
     * @see org.apache.tools.ant.Task#execute()
     */
    public void packIt() throws IOException, ClassNotFoundException {
        pack.copyIgnorableClassesToLocalHashSet();

        if (pack.hasCacheClassFiles())
            pack.setCache(true);

        pack.validateInput();
        String[] clsNames;
        if (pack.getClasses() != null) {
            // "classes" is specified (it has precedence)
            clsNames = ClassPathUtils.getStringArray(pack.getClasses());
        } else {
            String[] pkgNames = ClassPathUtils.getStringArray(
                    pack.getPackages());
            String cp2 = pack.getClassPath();


            ClassPackageExplorer pkgExplorer = new SimpleClassPackageExplorer(
                    cp2);
            Set cls = new HashSet();
            for (int i = 0; i < pkgNames.length; i++) {

                log(
                        "Looking for classes in package " +
                        pkgNames[i] +
                        " using " +
                        cp2);
                String[] tmp = pkgExplorer.listPackage(pkgNames[i]);
                for (int j = 0; j < tmp.length; j++)
                    cls.add(tmp[j]);
            }

            clsNames = new String[cls.size()];
            cls.toArray(clsNames);
            log("Classes to pack computed from given packages list");
        }
        setUpClassFilters();

        pack.computeDependencies(clsNames);


        // Add any additional class
        pack.addAdditionalClasses();

        // Write the resulting target jar
        pack.writeOutJar();
    }

    private void setUpClassFilters() {
        pack.setRefusedNames(new HashSet());
        if (pack.getIncludePkg() == null) {
            if (pack.getExcludePkg() == null)
                pack.setExcludePkg(Constants.DEFAULT_EXCLUDE_PACKAGES);
            setAcceptFilter();
        } else {
            pack.setAcceptFilter(
                    new PackagePrefixClassFilter(
                            getIncludedPackages(),
                            true));
        }

        if (pack.getExcludePkg() != null)
            log(
                    "Excluding packages prefixed with " +
                    pack.getExcludePkg());
        if (pack.getIncludePkg() != null)
            log(
                    "Including only packages prefixed with " +
                    pack.getIncludePkg());
    }

    private String[] getIncludedPackages() {
        return ClassPathUtils.getStringArray(pack.getIncludePkg());
    }

    private void setAcceptFilter() {
        String[] excludedPackages =
                ClassPathUtils.getStringArray(pack.getExcludePkg());
        log("excluded packages are:");
        for (int i = 0; i < excludedPackages.length; i++)
            log(excludedPackages[i]);
        pack.setAcceptFilter(
                new PackagePrefixClassFilter(
                        excludedPackages,
                        false));
    }

    public void log(String o, int i) {
        log(o);
    }

    JInfoFrame jif = new JInfoFrame();

    public void log(String o) {
        if (!jif.isVisible()) {
            jif.setSize(400, 400);
            jif.setVisible(true);

        }
        jif.println(o);
    }
}
