package classUtils.pack.util;

import classUtils.pack.util.CPoolReader;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Jan 1, 2005
 * <p/>
 * Time: 12:00:02 PM
 */
public interface ClassFilter {
    /**
     * Return true if the given classfile is accepted
     *
     * @param pkgname   the package name of the class
     * @param clsName   the class name
     * @param classFile the {@link classUtils.pack.util.CPoolReader.ClassFile
     *                  classfile object} for the class
     * @return boolean <b>true</b> if the class is to be accepted
     */
    public boolean accept(String pkgname,
                          String clsName,
                          CPoolReader.ClassFile classFile);
}
