package classUtils.pack;

import classUtils.pack.util.Pack;
import classUtils.putils.ClassPathUtils;
import futils.Futil;
import gui.In;

import java.io.File;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Jan 2, 2005
 * <p/>
 * Time: 11:28:50 AM
 */
public class PackUtils {
    //com.sun.media.jai, cannot be excluded
    //com.tornadolabs cannot be excluded
    //Package names are followed by a comma
    

    public static void main(String[] args) {
        pack();
    }

    private static void pack() {
        do {
            ClassPathUtils.restoreClassPath();
            if (In.getBoolean("want to set the class path?"))
                ClassPathUtils.fixClassPath();

            try {
                Class c = ClassPathUtils.getClass(
                        Futil.getReadFile("select a class file"));
                pack(c);
            } catch (Exception e) {
                In.message(e);


            }

        } while (In.getBoolean("go again?"));
    }

    public static void packTask() throws Exception {
        pack(math.benchmarks.Dhry.class);
       // pack(DependencyUtils.class);
        pack(ip.Main.class);
    }

    public static void pack(Class c) throws Exception {
        String name = c.getName();
        pack(name, new File(name + ".jar"));
    }

    public static void pack(String mainClass,
                            File targetJarFile) throws Exception {
        Pack p = new Pack();
        p.setManifestMainClass(mainClass);
        p.setClasses(mainClass);
        p.setTargetJarFile(targetJarFile);

        //p.printDependencies();
        p.packIt();
        System.out.println("done with:" + targetJarFile.getAbsolutePath());
    }
}
