package classUtils.javassist.sample.rmi;

import classUtils.javassist.CannotCompileException;
import classUtils.javassist.NotFoundException;
import classUtils.javassist.rmi.AppletServer;

import java.io.IOException;

public class ComputationServer {
    AppletServer as = null;

    // the following code cannot work on a running AppletServer.
    // how do we exportObjects on a live running AppletServer?
    public void exportObject(String name, Object obj) {

        try {
            as.end();
            initServer();
            as.exportObject(name, obj);
            as.run();
        } catch (IOException e) {
            e.printStackTrace();
        } catch (NotFoundException e) {
            e.printStackTrace();
        } catch (CannotCompileException e) {
            e.printStackTrace();
        }

    }


    private void initServer() throws IOException, NotFoundException, CannotCompileException {
        as = new AppletServer(5500);
    }

    public ComputationServer() {
        try {
            initServer();
            // you can export a new job with the same
            // name. The most recent export will be used.


            as.exportObject("job", new Job.IntJob());
            as.run();
        } catch (IOException e) {
            e.printStackTrace();
        } catch (NotFoundException e) {
            e.printStackTrace();
        } catch (CannotCompileException e) {
            e.printStackTrace();
        }
    }


    public static void main(String[] args) {
        ComputationServer cs
                = new ComputationServer();
        cs.exportObject("job",new Job());
    }
}
