/*
 * dumpclass.java
 *
 * Uses the class file decoders in util to dump out a
 * class file.
 * Written : 22 - May - 1996 by Chuck McManis
 */
package classUtils.dumper;

import java.util.Vector;

public class Main {
    public static void main(String args[]) {
        ClassFile cf[] = ClassFile.getClassFiles();
        printOutClassFilesWithMainMethods(cf);
    }
    public static void printOutClassFilesWithMainMethods(ClassFile cf[]) {
        for (int i=0; i < cf.length; i++)
            if (cf[i].hasMainMethod())
                System.out.println(cf[i]);
    }

    public static void printOutMainMethods(ClassFile cf[]) {
        for (int i = 0; i < cf.length; i++)
            printOutMainMethod(cf[i]);
    }

    public static void printOutMainMethod(ClassFile cf) {
        //System.out.println("class:" + cf.getClassName() + cf);
        MethodInfo mi[] = getMainMethods(cf.getMethods());
        if (mi==null) return;
        for (int i = 0; i < mi.length; i++)
            System.out.println(mi[i]);
    }

    public static MethodInfo[] getMainMethods(MethodInfo mi[]) {
        Vector v = new Vector();
        if (mi == null) return null;
        for (int i = 0; i < mi.length; i++) {
            String ms = mi[i].toString();
            boolean b = ms.indexOf("public") >= 0;
            boolean b1 = ms.indexOf("static") >= 0;
            boolean b3 = ms.indexOf("main") >= 0;
            boolean b4 = ms.indexOf("java.lang.String ") >= 0;
            boolean b5 = ms.indexOf("void") >= 0;
            if (b && b1 && b3 && b4 && b5)
                v.addElement(mi[i]);
        }
        MethodInfo mi2[] = new MethodInfo[v.size()];
        v.copyInto(mi2);
        return mi2;
    }

    public static MethodInfo[] getPublicStaticMethods(MethodInfo mi[]) {
        Vector v = new Vector();
        for (int i = 0; i < mi.length; i++) {
            String ms = mi[i].toString();
            if (ms.indexOf("public") >= 0 && ms.indexOf("static") >= 0)
                v.addElement(mi[i]);
        }
        MethodInfo mi2[] = new MethodInfo[v.size()];
        v.copyInto(mi2);
        return mi2;
    }

    public static MethodInfo[] getPublicMethods(MethodInfo mi[]) {
        Vector v = new Vector();
        for (int i = 0; i < mi.length; i++) {
            String ms = mi[i].toString();
            if (ms.indexOf("public") >= 0)
                v.addElement(mi[i]);
        }
        MethodInfo mi2[] = new MethodInfo[v.size()];
        v.copyInto(mi2);
        return mi2;
    }
}

