package classUtils.delegate;

import gui.ClosableJFrame;
import gui.run.RunButton;
import gui.run.RunCheckBox;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.util.Vector;

/**
 * DelegateGui class To replace inheritance with delegation: I dentify the
 * super class. Make an instance of the super class in the child. Using
 * semiautomatic static proxy delegation create a proxy for the primordial
 * super-class. Remove the extends clause. Replace all references to the
 * parent with references to the proxy.
 */
public class DelegateGui {
    private JFrame jf = new ClosableJFrame("Disambiguate");
    private JList duplicateJList = new JList();
    private JList doJList = new JList();
    private JScrollPane duplicateScrollPane = new JScrollPane();
    private JScrollPane selectedMethodsScrollPane = new JScrollPane();
    private JLabel selectedMethodLabel = new JLabel("Selected Method");
    private JLabel dupLabel = new JLabel("Duplicate Methods");
    private JPanel listPanel = getScrollPanels();
    private JPanel controlPanel = getControlPanel();
    private boolean isTopologicallySorted = false;
    private DelegateSynthesizer ds = null;

    public DelegateGui() {
    }

    public void setVisible(boolean v) {
        jf.setVisible(v);
    }

    public void setInstanceList(Vector v) {
        DelegateSynthesizer ds = getDelegateSynthesizer();
        for (int i = 0; i < v.size(); i++)
            ds.add(v.elementAt(i));
        ds.process();
        duplicateJList.setListData(ds.getDuplicateMethodVector());
        dupLabel.setText("Duplicate Methods: "
                +
                ds.getDuplicateMethodVector()
                .size());
        selectedMethodLabel.setText("selected Method: " +
                ds.getCompositeMethodVector()
                .size());
    }

    public void init() {
        buildScrollPane();
        duplicateJList.setVisible(true);
        initDoScrollPane();
        doJList.setVisible(true);
        initListPanel();
        addPanelsSetLayout();
        jf.setSize(650, 250);
    }

    private void addPanelsSetLayout() {
        Container c = jf.getContentPane();
        c.setLayout(new BorderLayout());
        c.add(getCounterPanel(), "North");
        c.add(listPanel, "Center");
        c.add(controlPanel, "South");
    }

    private JPanel getScrollPanels() {
        JPanel jp = new JPanel();
        jp.setLayout(new GridLayout(1, 0));
        jp.add(duplicateScrollPane);
        jp.add(selectedMethodsScrollPane);
        return jp;
    }

    private JPanel getCounterPanel() {
        JPanel jp = new JPanel();
        jp.add(dupLabel);
        jp.add(selectedMethodLabel);
        jp.setLayout(new GridLayout(1, 0));
        return jp;
    }

    private JPanel getControlPanel() {
        JPanel jp = new JPanel();
        jp.setLayout(new FlowLayout());
        jp.add(new RunButton("generate rmi code") {
            public void run() {
                generateRmiCode();
            }
        });
        jp.add(new RunButton("process") {
            public void run() {
                process();
            }
        });
        jp.add(new RunButton("add") {
            public void run() {
                doAdd();
            }
        });
        jp.add(new RunButton("Delete") {
            public void run() {
                doDelete();
            }
        });
        jp.add(new RunCheckBox("topological sorting") {
            public void run() {
                isTopologicallySorted = isSelected();
            }
        });
        jp.add(new RunButton("exit") {
            public void run() {
                exit();
            }
        });
        return jp;
    }

    private void initListPanel() {
        //getListPanel().setVisible(true);
        listPanel.setLayout(new GridLayout(1, 2));
    }

    private void initDoScrollPane() {
        selectedMethodsScrollPane.setSize(new Dimension(300, 190));
        selectedMethodsScrollPane.setVisible(true);
        selectedMethodsScrollPane.setLocation(new Point(370, 30));
        selectedMethodsScrollPane.getViewport().add(doJList);
    }

    private void buildScrollPane() {
        duplicateScrollPane.setSize(new Dimension(300, 190));
        duplicateScrollPane.setLocation(new Point(10, 30));
        duplicateScrollPane.getViewport().add(duplicateJList);
    }

    private boolean isShowing = false;

    public void addNotify() {
        jf.addNotify();
        if (isShowing) return;

        // move components to account for insets
        Insets insets = jf.getInsets();
        Component[] components = jf.getComponents();
        for (int i = 0;
             i < components.length;
             i++) {
            Point location = components[i].getLocation();
            location.move(location.x,
                    location.y +
                    insets.top);
            components[i].setLocation(location);
        }
        isShowing = true;
    }

    void exit() {
        jf.setVisible(false);
        jf.dispose();
        System.exit(0);
    }

    public void doListValueChanged(javax.swing.event.ListSelectionEvent e) {
    }

    public DelegateSynthesizer getDelegateSynthesizer() {
        if (ds == null)
            ds = new DelegateSynthesizer();
        return ds;
    }

    private void doAdd() {
        Object o =
                duplicateJList.getSelectedValue();
        int i = duplicateJList.getSelectedIndex();
        if (getDelegateSynthesizer()
                .getDuplicateMethodVector()
                .size() ==
                0 ||
                i == -1) {
            JOptionPane.showMessageDialog(null,
                    "Please select a method"
                    +
                    " from Duplicate Methods window",
                    "STOP",
                    JOptionPane.ERROR_MESSAGE);
            return;
        }
        getDelegateSynthesizer()
                .removeDupMethod(o);
        // add to do list
        getDelegateSynthesizer().addDoMethod(o);
        //re-display the duplicate list
        duplicateJList.setListData(getDelegateSynthesizer()
                .getDuplicateMethodVector());
        //refresh the do list
        doJList.setListData(getDelegateSynthesizer()
                .getCompositeMethodVector());
        dupLabel.setText("Duplicate Methods: " +
                getDelegateSynthesizer()
                .getDuplicateMethodVector()
                .size());
        selectedMethodLabel.setText("selected Method: " +
                getDelegateSynthesizer()
                .getCompositeMethodVector()
                .size());
    }

    private void doDelete() {
        Object o = doJList.getSelectedValue();
        int i = doJList.getSelectedIndex();
        DelegateSynthesizer delegateSynthesizer = getDelegateSynthesizer();
        Vector doMethodList = delegateSynthesizer
                .getCompositeMethodVector();
        if (doMethodList
                .size() ==
                0 ||
                i == -1) {
            JOptionPane.showMessageDialog(null,
                    "Please select a method from Chosed Methods Window",
                    "STOP",
                    JOptionPane.ERROR_MESSAGE);
            return;
        }
        //delete from the do list
        delegateSynthesizer.removeDoMethod(o);
        // add to dup list
        delegateSynthesizer.addDupMethod(o);
        //re-display the duplicate list
        Vector dupMethodList = delegateSynthesizer.getDuplicateMethodVector();
        duplicateJList.setListData(dupMethodList);
        //refresh the do list
        doJList.setListData(doMethodList);
        dupLabel.setText("Duplicate Methods: " +
                dupMethodList.size());
        selectedMethodLabel.setText("selected Method: " +
                doMethodList.size());
    }
      private void generateRmiCode() {
        DelegateSynthesizer ds = getDelegateSynthesizer();
        ds.setToplogicalSorting(isTopologicallySorted);
        System.out.println(ds);
    }
    private void process() {
        DelegateSynthesizer ds = getDelegateSynthesizer();
        ds.setToplogicalSorting(isTopologicallySorted);
        ds.createFile();
    }

    public void setTopologicallySorted(boolean isTopologicallySorted) {
        this.isTopologicallySorted = isTopologicallySorted;
    }
}