package bookExamples.ch44Printing;

import bookExamples.ch44Printing.*;

import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;

/**
 * @version 	1.0
 * @author
 */
public class LabelPrinter {
    private static final int INCH = 72;

    public LabelPrinter(MailingLabelList ll) {
        PrinterJob pJob = PrinterJob.getPrinterJob();
        displayPrintDialog(pJob, ll);

    }
    public static void main(String args[]) {
        MailingLabelList ll = new MailingLabelList();
        for (int i=0; i < 20; i++) {
            MailingLabel ml = new bookExamples.ch44Printing.MailingLabel();
            ml.add("test label#"+i);
            ml.add("300 North Benson Rd.");
            ml.add("Fairfield, CT, 06430");
            ll.add(ml);
        }
        new LabelPrinter(ll);
        System.exit(0);
    }


    private void displayPrintDialog(PrinterJob pJob, MailingLabelList v) {
        if (pJob.printDialog()) {
            print(v,pJob);
            try {
                print(pJob);
            } catch (PrinterException e) {
                System.out.println(e.getMessage());
            }
        }
    }

    private void print(PrinterJob pJob)
            throws PrinterException {
        pJob.print();
    }

    public void print(MailingLabelList ll,PrinterJob pj) {
        //set up a format
        PageFormat fmt = pj.defaultPage();
        //define the orientation
        fmt.setOrientation(PageFormat.PORTRAIT);
        //set the paper size
        Paper paper = fmt.getPaper();
        paper.setSize(8.5 * INCH, 11 * INCH);
        //define the full area as imageable
        paper.setImageableArea(0 * INCH, 0 * INCH, 8.5 * INCH, 11 * INCH);
        //set this paper as the current format
        fmt.setPaper(paper);

        //show the page format dialog for the heck of it
        //pj.pageDialog(fmt);
        //create a printable page
        pj.setPrintable(new bookExamples.ch44Printing.PrintableLabel(ll), fmt);
    }
}
