package bookExamples.ch26Graphics.graphics;

import gui.ClosableJFrame;

import java.awt.*;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class AffineExample extends ClosableJFrame {
    public static void main(String args[]) {
        new AffineExample();
    }

    AffineExample() {
        super("AffineFrame");
        setSize(200, 200);
        show();
    }

    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D) g;
        Point2D location = new Point2D.Float(20, 30);
        Point2D location1 = new Point2D.Float(40, 50);
        drawArrow(g2, 2, 2, location, theta);
        theta = theta + 0.1;
    }

    private void drawArrow(Graphics2D g2,
                           float sx, float sy,
                           Point2D location,
                           double angle) {
        GeneralPath gp = getArrow();
        AffineTransform at = new AffineTransform();
        at.setToTranslation(location.getX(), location.getY());
        at.scale(sx, sy);
        g2.setTransform(at);
        at.rotate(angle * Math.PI / 180, 10, 10);
        g2.setTransform(at);
        g2.draw(gp);
        //g2.setXORMode(getBackground());
        //g2.draw(gp);
        //g2.setXORMode(getForeground());
    }

    double theta = 30;

    private GeneralPath getArrow() {
        GeneralPath gp = new GeneralPath(GeneralPath.WIND_EVEN_ODD);
        gp.moveTo(0f, -15f);
        gp.lineTo(10f, 5f);
        gp.lineTo(5f, 5f);
        gp.lineTo(5f, 15f);
        gp.lineTo(-5, 15f);
        gp.lineTo(-5f, 5f);
        gp.lineTo(-10f, 5f);
        gp.closePath();
        return gp;
    }
}
