package bookExamples.ch26Graphics.draw2d;

import javax.swing.*;
import java.awt.*;
import java.awt.image.BufferedImage;

public class ZoomTargetPanel extends JPanel implements ZoomTarget {
    public ZoomTargetPanel () {
        setPreferredSize(new Dimension( 100, 100));
        setMaximumSize(new Dimension(100, 100));
    }

    public void zoomImage(BufferedImage img) {
        Rectangle r = getBounds();
        Graphics g = getGraphics();

        g.clearRect(0, 0, r.width, r.height);
        int[] coords = Coords.scaleCoords(img.getWidth(), img.getHeight(), r.width, r.height);
        g.drawImage(img, coords[0], coords[1], coords[2], coords[3], null);
    }
}
