package bookExamples.ch26Graphics.draw2d;

import javax.swing.*;
import java.awt.*;
import java.awt.image.BufferedImage;

public class ZoomSourcePanel extends JPanel implements Rubberbandable {
    private JLabel label;
    private ZoomTarget zoomtarget;

    public ZoomSourcePanel(String imagefile, ZoomTarget zoomtarget) {
        Rubberband rubberband = new Rubberband(this);
        addMouseListener(rubberband);
        addMouseMotionListener(rubberband);

        JLabel label = new JLabel(new ImageIcon(imagefile));
        add(label);

        this.label = label;
        this.zoomtarget = zoomtarget;
    }

    public void onRubberbandEnd(int startX, int startY, int endX, int endY) {
        Rectangle r = label.getBounds();
        BufferedImage img = new BufferedImage(r.width, r.height, BufferedImage.TYPE_INT_RGB);
        img.getGraphics().drawImage(((ImageIcon)label.getIcon()).getImage(), 0, 0, null);

        int[] coords = Coords.translateCoords(startX, startY, endX, endY);
        BufferedImage subimg = img.getSubimage(coords[0], coords[1], coords[2], coords[3]);
        zoomtarget.zoomImage(subimg);
    }
}
